/*
 * Decompiled with CFR 0.152.
 */
package salted.packedup.data.recipes;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import salted.packedup.PackedUp;
import salted.packedup.common.registry.PUItems;
import salted.packedup.common.tag.PUTags;
import salted.packedup.data.utils.NameUtils;

public class PURecipeBuilder
extends RecipeProvider {
    public PURecipeBuilder(PackOutput pOutput) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
    }

    protected static ResourceLocation recipeDir(String modID, String path) {
        return new ResourceLocation(modID, path);
    }

    protected static void simpleCombined(ItemLike product, ItemLike resource, boolean split, Consumer<FinishedRecipe> consumer) {
        PURecipeBuilder.simpleCompact(resource, product, consumer);
        PURecipeBuilder.simpleShapeless(product, resource, split, consumer);
    }

    protected static void simpleCombined(ItemLike product, ItemLike resource, boolean before, String type, Consumer<FinishedRecipe> consumer) {
        PURecipeBuilder.simpleCompact(resource, product, consumer);
        PURecipeBuilder.simpleShapeless(product, resource, before, type, consumer);
    }

    protected static void modifiedCombined(ItemLike product, ItemLike resource, Consumer<FinishedRecipe> consumer) {
        PURecipeBuilder.modifiedCompact(resource, product, consumer);
        PURecipeBuilder.modifiedShapeless(product, resource, consumer);
    }

    protected static void simpleCompact(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)1).m_126130_("###").m_126130_("###").m_126130_("###").m_126127_(Character.valueOf('#'), input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176498_(consumer);
    }

    protected static void modifiedCompact(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)1).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176498_(consumer);
    }

    protected static void simpleSmallCompact(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String resource = NameUtils.itemName(output.m_5456_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)1).m_126130_("##").m_126130_("##").m_126127_(Character.valueOf('#'), input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, PURecipeBuilder.recipeDir("packedup", resource + "_from_" + item));
    }

    protected static void simpleStacked(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String resource = NameUtils.itemName(output.m_5456_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)1).m_126130_("#").m_126130_("#").m_126127_(Character.valueOf('#'), input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, PURecipeBuilder.recipeDir("packedup", resource + "_from_" + item));
    }

    protected static void simpleSlab(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)6).m_126130_("###").m_126127_(Character.valueOf('#'), input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176498_(consumer);
    }

    protected static void simpleStairs(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)4).m_126130_("#  ").m_126130_("## ").m_126130_("###").m_126127_(Character.valueOf('#'), input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176498_(consumer);
    }

    protected static void simpleShapeless(ItemLike input, ItemLike output, boolean split, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String resource = NameUtils.itemName(output.m_5456_());
        Object type = "_" + item;
        if (split) {
            type = NameUtils.nameFromSplit(item, resource, false);
        }
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).m_126209_(input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, PURecipeBuilder.recipeDir("packedup", resource + "_from" + (String)type));
    }

    protected static void simpleShapeless(ItemLike input, ItemLike output, boolean before, String type, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String resource = NameUtils.itemName(output.m_5456_());
        String prefix = "";
        if (before) {
            prefix = NameUtils.nameFromSplit(item, resource, true);
        }
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)9).m_126209_(input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, PURecipeBuilder.recipeDir("packedup", resource + "_from_" + prefix + type));
    }

    protected static void modifiedShapeless(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String resource = NameUtils.itemName(output.m_5456_());
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)4).m_126209_(input).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, PURecipeBuilder.recipeDir("packedup", resource + "_from_" + item));
    }

    protected static void bookBundleDyeing(TagKey<Item> dye, ItemLike output, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)8).m_126130_("###").m_126130_("#o#").m_126130_("###").m_206416_(Character.valueOf('#'), PUTags.BOOK_BUNDLES).m_206416_(Character.valueOf('o'), dye).m_126132_("has_book_bundle", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)PUItems.BOOK_BUNDLE.get()})).m_176498_(consumer);
    }

    protected static void simpleThatch(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        PURecipeBuilder.simpleFunace(input, output, consumer);
        PURecipeBuilder.simpleCampfire(input, output, consumer);
        PURecipeBuilder.simpleSmoking(input, output, consumer);
    }

    protected static void simpleFunace(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{input});
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (float)0.35f, (int)200).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176498_(consumer);
    }

    protected static void simpleSmoking(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String itemOut = PackedUp.resLoc(NameUtils.itemName(output.m_5456_())).toString();
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{input});
        SimpleCookingRecipeBuilder.m_246159_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (float)0.35f, (int)100).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176500_(consumer, itemOut + "_from_smoking");
    }

    protected static void simpleBlasting(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String itemOut = PackedUp.resLoc(NameUtils.itemName(output.m_5456_())).toString();
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{input});
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (float)0.35f, (int)100).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176500_(consumer, itemOut + "_from_blasting");
    }

    protected static void simpleCampfire(ItemLike input, ItemLike output, Consumer<FinishedRecipe> consumer) {
        String item = NameUtils.itemName(input.m_5456_());
        String itemOut = PackedUp.resLoc(NameUtils.itemName(output.m_5456_())).toString();
        Ingredient ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{input});
        SimpleCookingRecipeBuilder.m_247020_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (float)0.35f, (int)600).m_126132_("has_" + item, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_176500_(consumer, itemOut + "_from_campfire_cooking");
    }
}

