/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.File;
import java.io.IOException;
import net.jomcraft.defaultsettings.DefaultSettings;
import net.jomcraft.defaultsettings.FileUtil;
import net.jomcraft.defaultsettings.ICoreHook;
import net.jomcraft.defaultsettings.KeyContainer;
import net.jomcraft.defaultsettings.KeyPlaceholder;
import net.jomcraft.jcplugin.FileUtilNoMC;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.Logger;

public class ForgeCoreHook
implements ICoreHook {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)Component.m_237113_((String)(ChatFormatting.RED + "Please wait until the last request has finished")));

    @Override
    public File getMCDataDir() {
        return FileUtilNoMC.mcDataDir;
    }

    @Override
    public File getMainFolder() {
        return FileUtilNoMC.getMainFolder();
    }

    @Override
    public String getActiveProfile() {
        return FileUtilNoMC.activeProfile;
    }

    @Override
    public KeyPlaceholder[] getKeyMappings() {
        KeyMapping[] mappings = Minecraft.m_91087_().f_91066_.f_92059_;
        if (mappings == null || mappings.length == 0) {
            return new KeyPlaceholder[0];
        }
        KeyPlaceholder[] keys = new KeyPlaceholder[mappings.length];
        for (int i = 0; i < mappings.length; ++i) {
            keys[i] = new KeyPlaceholder(mappings[i].m_90860_(), mappings[i].getKey().toString(), mappings[i].getKeyModifier().name());
        }
        return keys;
    }

    @Override
    public void resetMappings() {
        KeyMapping.m_90854_();
    }

    @Override
    public void clearKeyBinds() {
        DefaultSettings.keyRebinds.clear();
    }

    @Override
    public void putKeybind(String first, String second, String third) {
        DefaultSettings.keyRebinds.put(first, new KeyContainer(InputConstants.m_84851_((String)second), third != null ? KeyModifier.valueFromString((String)third) : KeyModifier.NONE));
    }

    @Override
    public boolean keybindExists(String key) {
        return DefaultSettings.keyRebinds.containsKey(key);
    }

    @Override
    public void setKeybind(KeyPlaceholder key, boolean init) {
        KeyMapping[] mappings = Minecraft.m_91087_().f_91066_.f_92059_;
        for (int i = 0; i < mappings.length; ++i) {
            if (!mappings[i].m_90860_().equals(key.name)) continue;
            KeyContainer container = DefaultSettings.keyRebinds.get(key.name);
            if (init) {
                mappings[i].m_90848_(container.input);
            }
            mappings[i].f_90814_ = container.input;
            ObfuscationReflectionHelper.setPrivateValue(KeyMapping.class, (Object)mappings[i], (Object)container.modifier, (String)"keyModifierDefault");
            mappings[i].setKeyModifierAndCode(mappings[i].getDefaultKeyModifier(), container.input);
            break;
        }
    }

    @Override
    public void sendSuccess(Object source, String text, int color) {
        if (source instanceof CommandSourceStack) {
            ((CommandSourceStack)source).m_288197_(() -> Component.m_237113_((String)text).m_130940_(ChatFormatting.m_126647_((int)color)), true);
        }
    }

    @Override
    public Exception throwFailedException() {
        return FAILED_EXCEPTION.create();
    }

    @Override
    public boolean hasDSShutDown() {
        return DefaultSettings.shutDown;
    }

    @Override
    public Logger getDSLog() {
        return DefaultSettings.log;
    }

    @Override
    public String shutdownReason() {
        return DefaultSettings.shutdownReason;
    }

    @Override
    public boolean isOtherCreator() {
        return FileUtilNoMC.otherCreator;
    }

    @Override
    public boolean disableCreatorCheck() {
        return FileUtilNoMC.privateJson.disableCreatorCheck;
    }

    @Override
    public boolean checkChangedConfig() {
        return FileUtilNoMC.checkChangedConfig();
    }

    @Override
    public boolean checkForConfigFiles() {
        return FileUtilNoMC.checkForConfigFiles();
    }

    @Override
    public void checkMD5(boolean updateExisting, boolean configs, String file) throws IOException {
        FileUtilNoMC.checkMD5((boolean)updateExisting, (boolean)configs, (String)file);
    }

    @Override
    public void copyAndHashPrivate(boolean options, boolean configs) throws NullPointerException, IOException {
        FileUtilNoMC.copyAndHashPrivate((boolean)options, (boolean)configs);
    }

    @Override
    public boolean keysFileExist() {
        return FileUtilNoMC.keysFileExist();
    }

    @Override
    public boolean optionsFilesExist() {
        return FileUtilNoMC.optionsFilesExist();
    }

    @Override
    public boolean serversFileExists() {
        return FileUtilNoMC.serversFileExists();
    }

    @Override
    public boolean checkChanged() {
        return FileUtil.checkChanged();
    }

    @Override
    public void saveKeys() throws IOException {
        FileUtil.saveKeys();
    }

    @Override
    public boolean saveOptions() throws IOException {
        return FileUtil.saveOptions();
    }

    @Override
    public void saveServers() throws IOException {
        FileUtilNoMC.saveServers();
    }

    @Override
    public void restoreKeys(boolean update, boolean initial) throws IOException {
        FileUtil.restoreKeys(update, initial);
    }
}

