/*
 * Decompiled with CFR 0.152.
 */
package net.jomcraft.defaultsettings.commands;

import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;

public class OperationArguments
implements ArgumentType<String> {
    private static final List<String> ARGUMENTS = Arrays.asList("override", "forceOverride");
    private static final List<String> ARGUMENTS_LIMITED = Arrays.asList("forceOverride");
    private final boolean limited;

    public OperationArguments(boolean limited) {
        this.limited = limited;
    }

    public static OperationArguments operationArguments(boolean limited) {
        return new OperationArguments(limited);
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        return reader.readUnquotedString();
    }

    public static String getString(CommandContext<?> context, String name) {
        return (String)context.getArgument(name, String.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(this.limited ? ARGUMENTS_LIMITED : ARGUMENTS, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return ARGUMENTS;
    }

    public static class Info
    implements ArgumentTypeInfo<OperationArguments, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buffer) {
            buffer.writeBoolean(template.limited);
        }

        public Template deserializeFromNetwork(FriendlyByteBuf buffer) {
            boolean limited = buffer.readBoolean();
            return new Template(limited);
        }

        public void serializeToJson(Template template, JsonObject json) {
            json.addProperty("limited", Boolean.valueOf(template.limited));
        }

        public Template unpack(OperationArguments argument) {
            return new Template(argument.limited);
        }

        public class Template
        implements ArgumentTypeInfo.Template<OperationArguments> {
            final boolean limited;

            Template(boolean limited) {
                this.limited = limited;
            }

            public OperationArguments instantiate(CommandBuildContext p_223435_) {
                return new OperationArguments(this.limited);
            }

            public ArgumentTypeInfo<OperationArguments, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

