/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="travelerscompass", value={Dist.CLIENT})
public class ClientEvents {
    public static int DEFAULT_X_OFFSET = 5;
    public static int DEFAULT_Y_OFFSET = 5;

    @SubscribeEvent
    public void onRenderTick(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (this.shouldShow() && player != null) {
            TravelersCompassItem compassStack;
            GuiGraphics guiGraphics = event.getGuiGraphics();
            Font font = Minecraft.m_91087_().f_91062_;
            ItemStack stack = player.m_21205_();
            ItemStack inventoryStack = null;
            Item item = stack.m_41720_();
            if (item instanceof TravelersCompassItem && (compassStack = (TravelersCompassItem)item).hudModeRequiresHeld(stack) && (mc.f_91080_ == null || compassStack.hudWithChatMode(stack) && mc.f_91080_ instanceof ChatScreen)) {
                ClientEvents.renderHud(guiGraphics, (Player)player, font, stack, compassStack);
            } else {
                TravelersCompassItem compassStack2;
                Item item2;
                for (ItemStack item3 : player.m_150109_().f_35974_) {
                    if (!(item3.m_41720_() instanceof TravelersCompassItem)) continue;
                    inventoryStack = item3;
                    break;
                }
                if (inventoryStack != null && (item2 = inventoryStack.m_41720_()) instanceof TravelersCompassItem && (compassStack2 = (TravelersCompassItem)item2).hudMode(inventoryStack) && (mc.f_91080_ == null || compassStack2.hudWithChatMode(inventoryStack) && mc.f_91080_ instanceof ChatScreen)) {
                    ClientEvents.renderHud(guiGraphics, (Player)player, font, inventoryStack, compassStack2);
                }
            }
        }
    }

    public static int getXOffset(int preset, Component s, int xOffset, Font font) {
        Minecraft mc = Minecraft.m_91087_();
        return switch (preset) {
            case 0 -> xOffset;
            case 1 -> mc.m_91268_().m_85445_() - xOffset - font.m_92852_((FormattedText)s);
            case 2 -> mc.m_91268_().m_85445_() / 2 - xOffset - font.m_92852_((FormattedText)s) / 2;
            default -> 0;
        };
    }

    public static void renderHud(GuiGraphics guiGraphics, Player player, Font font, ItemStack stack, TravelersCompassItem compassItem) {
        BlockPos targetPos = TravelersCompassItem.getFoundPosition(stack);
        BlockPos userPos = player.m_20097_();
        String targetName = compassItem.foundTarget(stack);
        int preset = compassItem.getHudAlign(stack);
        int xOffset = compassItem.getXHudPos(stack) + DEFAULT_X_OFFSET;
        int yOffset = compassItem.getYHudPos(stack) + DEFAULT_Y_OFFSET;
        MutableComponent compact_state = Component.m_237115_((String)"options.travelerscompass.hud.compact_state");
        MutableComponent state = Component.m_237115_((String)"options.travelerscompass.hud.state");
        MutableComponent empty = Component.m_237115_((String)"options.travelerscompass.hud.empty").m_130940_(ChatFormatting.GRAY);
        MutableComponent not_selected = Component.m_237115_((String)"options.travelerscompass.hud.not_selected").m_130940_(ChatFormatting.GRAY);
        MutableComponent paused = Component.m_237115_((String)"options.travelerscompass.hud.paused").m_130940_(ChatFormatting.GRAY);
        MutableComponent not_enough_exp = Component.m_237115_((String)"options.travelerscompass.hud.not_enough_exp").m_130940_(ChatFormatting.GRAY);
        MutableComponent found = Component.m_237115_((String)"options.travelerscompass.hud.found").m_130940_(ChatFormatting.GRAY);
        MutableComponent searching = Component.m_237115_((String)"options.travelerscompass.hud.searching").m_130940_(ChatFormatting.GRAY);
        MutableComponent target = Component.m_237115_((String)"options.travelerscompass.hud.target");
        MutableComponent last_target = Component.m_237115_((String)"options.travelerscompass.hud.last_target");
        MutableComponent position = Component.m_237115_((String)"options.travelerscompass.hud.position");
        MutableComponent distance = Component.m_237115_((String)"options.travelerscompass.hud.distance");
        ArrayList<Integer> modes = compassItem.selectedModes(stack);
        List<Integer> elementsToExclude = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8);
        modes.retainAll(elementsToExclude);
        boolean nothingSelected = modes.isEmpty();
        int type = compassItem.getHudType(stack);
        if (type == 1) {
            guiGraphics.m_280430_(font, (Component)state, ClientEvents.getXOffset(preset, (Component)state, xOffset, font), yOffset, 0xFFFFFF);
            if (((Boolean)TCConfig.xpDrain.get()).booleanValue() && !TravelersCompassItem.canSearch(player)) {
                guiGraphics.m_280430_(font, (Component)not_enough_exp, ClientEvents.getXOffset(preset, (Component)empty, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (TravelersCompassItem.getFoundPosition(stack) != null) {
                guiGraphics.m_280430_(font, (Component)found, ClientEvents.getXOffset(preset, (Component)found, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (CompassContainer.container(stack).m_7983_()) {
                guiGraphics.m_280430_(font, (Component)empty, ClientEvents.getXOffset(preset, (Component)empty, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (nothingSelected) {
                guiGraphics.m_280430_(font, (Component)not_selected, ClientEvents.getXOffset(preset, (Component)not_selected, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (compassItem.isPaused(stack)) {
                guiGraphics.m_280430_(font, (Component)paused, ClientEvents.getXOffset(preset, (Component)paused, xOffset, font), yOffset + 10, 0xAAAAAA);
            } else if (TravelersCompassItem.getFoundPosition(stack) == null) {
                guiGraphics.m_280430_(font, (Component)searching, ClientEvents.getXOffset(preset, (Component)searching, xOffset, font), yOffset + 10, 0xAAAAAA);
            }
            if (targetPos != null) {
                guiGraphics.m_280430_(font, (Component)target, ClientEvents.getXOffset(preset, (Component)target, xOffset, font), yOffset + 25, 0xFFFFFF);
                guiGraphics.m_280488_(font, targetName, ClientEvents.getXOffset(preset, (Component)Component.m_237113_((String)targetName), xOffset, font), yOffset + 35, compassItem.hasFavoriteItem(stack) ? 13939050 : 0xAAAAAA);
                String cords = targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_();
                guiGraphics.m_280430_(font, (Component)position, ClientEvents.getXOffset(preset, (Component)position, xOffset, font), yOffset + 50, 0xFFFFFF);
                guiGraphics.m_280488_(font, cords, ClientEvents.getXOffset(preset, (Component)Component.m_237113_((String)cords), xOffset, font), yOffset + 60, 0xAAAAAA);
                guiGraphics.m_280430_(font, (Component)distance, ClientEvents.getXOffset(preset, (Component)distance, xOffset, font), yOffset + 75, 0xFFFFFF);
                guiGraphics.m_280488_(font, String.valueOf((int)Math.sqrt(userPos.m_123331_((Vec3i)targetPos))), ClientEvents.getXOffset(preset, (Component)Component.m_237113_((String)String.valueOf((int)Math.sqrt(userPos.m_123331_((Vec3i)targetPos)))), xOffset, font), yOffset + 85, 0xAAAAAA);
            }
        } else if (type == 0) {
            boolean lackOfExp;
            xOffset -= 2;
            yOffset -= 2;
            MutableComponent state1 = Component.m_237113_((String)"").m_130940_(ChatFormatting.GRAY);
            boolean bl = lackOfExp = (Boolean)TCConfig.xpDrain.get() != false && !TravelersCompassItem.canSearch(player);
            if (lackOfExp) {
                state1 = not_enough_exp;
            } else if (TravelersCompassItem.getFoundPosition(stack) != null) {
                state1 = found;
            } else if (CompassContainer.container(stack).m_7983_()) {
                state1 = empty;
            } else if (nothingSelected) {
                state1 = not_selected;
            } else if (compassItem.isPaused(stack)) {
                state1 = paused;
            } else if (TravelersCompassItem.getFoundPosition(stack) == null) {
                state1 = searching;
            }
            MutableComponent state0 = Component.m_237113_((String)(compact_state.getString() + ": ")).m_7220_((Component)state1);
            guiGraphics.m_280430_(font, (Component)state0, ClientEvents.getXOffset(preset, (Component)state0, xOffset, font), yOffset, 0xFFFFFF);
            if (targetPos != null) {
                String cords = targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_();
                MutableComponent coloredTargetName = Component.m_237113_((String)targetName).m_130948_(Component.m_237113_((String)targetName).m_7383_().m_178520_(compassItem.hasFavoriteItem(stack) ? 13939050 : 0xAAAAAA));
                MutableComponent target0 = lackOfExp ? Component.m_237113_((String)(last_target.getString() + ": ")).m_7220_((Component)coloredTargetName) : Component.m_237113_((String)(target.getString() + ": ")).m_7220_((Component)coloredTargetName);
                guiGraphics.m_280430_(font, (Component)target0, ClientEvents.getXOffset(preset, (Component)target0, xOffset, font), yOffset + 10, 0xFFFFFF);
                MutableComponent position0 = Component.m_237113_((String)(position.getString() + ": ")).m_7220_((Component)Component.m_237113_((String)cords).m_130940_(ChatFormatting.GRAY));
                guiGraphics.m_280430_(font, (Component)position0, ClientEvents.getXOffset(preset, (Component)position0, xOffset, font), yOffset + 20, 0xFFFFFF);
                MutableComponent distance0 = Component.m_237113_((String)(distance.getString() + ": ")).m_7220_((Component)Component.m_237113_((String)String.valueOf((int)Math.sqrt(userPos.m_123331_((Vec3i)targetPos)))).m_130940_(ChatFormatting.GRAY));
                guiGraphics.m_280430_(font, (Component)distance0, ClientEvents.getXOffset(preset, (Component)distance0, xOffset, font), yOffset + 30, 0xFFFFFF);
            }
        }
    }

    private boolean shouldShow() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91073_ != null && !mc.f_91066_.f_92062_ && !mc.f_91066_.f_92063_;
    }
}

