/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.client.screen;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.client.components.ButtonType;
import com.nine.travelerscompass.client.components.ConfigButton;
import com.nine.travelerscompass.client.components.HUDButton;
import com.nine.travelerscompass.client.components.InventoryButton;
import com.nine.travelerscompass.client.components.TabButton;
import com.nine.travelerscompass.client.components.TraderButton;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.network.NetworkHandler;
import com.nine.travelerscompass.common.network.packet.SearchButtonPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class CompassScreen
extends AbstractContainerScreen<CompassMenu> {
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("travelerscompass:textures/gui/container/compass_screen_1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("travelerscompass:textures/gui/container/compass_screen_2.png");
    private static final ResourceLocation WIDGETS = new ResourceLocation("travelerscompass:textures/gui/component/gui_components.png");
    private TabButton configButton;
    private TabButton searchButton;
    private TabButton statusButton;
    private ConfigButton mobButton;
    private ConfigButton blockButton;
    private ConfigButton containerButton;
    private ConfigButton itemEntityButton;
    private TraderButton villagerButton;
    private ConfigButton fluidButton;
    private ConfigButton spawnerButton;
    private ConfigButton infoButton;
    private ConfigButton pauseButton;
    private InventoryButton mobsInvButton;
    private ConfigButton dropsButton;
    private ConfigButton wideSearchButton;
    private ConfigButton blocksDistanceButton;
    private ConfigButton mobsDistanceButton;
    private ConfigButton containersDistanceButton;
    private ConfigButton wideDistanceButton;
    private ConfigButton prioritySwitch;
    private ConfigButton labelSwitch;
    private ConfigButton fullResetButton;
    private ConfigButton soundButton;
    private ConfigButton lazyButton;
    private HUDButton hudButton;

    public CompassScreen(CompassMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.f_97727_ = 172;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.mobButton = new ConfigButton(this.f_97735_ + 22, this.f_97736_ + 42, ButtonType.MOBS);
        this.containerButton = new ConfigButton(this.f_97735_ + 6, this.f_97736_ + 10, ButtonType.CONTAINERS);
        this.blockButton = new ConfigButton(this.f_97735_ + 6, this.f_97736_ + 42, ButtonType.BLOCKS);
        this.itemEntityButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 10, ButtonType.DROPPED_ITEMS);
        this.fluidButton = new ConfigButton(this.f_97735_ + 22, this.f_97736_ + 26, ButtonType.FLUIDS);
        this.spawnerButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 26, ButtonType.SPAWNERS);
        this.dropsButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 42, ButtonType.DROPS);
        this.pauseButton = new ConfigButton(this.f_97735_ + 6, this.f_97736_ + 58, ButtonType.PAUSE);
        this.infoButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 58, ButtonType.INFO);
        this.wideSearchButton = new ConfigButton(this.f_97735_ + 22, this.f_97736_ + 58, ButtonType.WIDE_SEARCH);
        this.blocksDistanceButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 10, ButtonType.BLOCKS_DISTANCE);
        this.mobsDistanceButton = new ConfigButton(this.f_97735_ + 22, this.f_97736_ + 26, ButtonType.MOBS_DISTANCE);
        this.containersDistanceButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 26, ButtonType.CONTAINERS_DISTANCE);
        this.wideDistanceButton = new ConfigButton(this.f_97735_ + 22, this.f_97736_ + 10, ButtonType.WIDE_DISTANCE);
        this.prioritySwitch = new ConfigButton(this.f_97735_ + 22, this.f_97736_ + 42, ButtonType.PRIORITY_SWITCH);
        this.labelSwitch = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 42, ButtonType.LABELS);
        this.fullResetButton = new ConfigButton(this.f_97735_ + 38, this.f_97736_ + 58, ButtonType.FULL_RESET);
        this.soundButton = new ConfigButton(this.f_97735_ + 6, this.f_97736_ + 10, ButtonType.SOUND);
        this.lazyButton = new ConfigButton(this.f_97735_ + 6, this.f_97736_ + 26, ButtonType.LAZY_MODE);
        this.villagerButton = new TraderButton(this.f_97735_ + 22, this.f_97736_ - 14, 14, 38);
        this.hudButton = new HUDButton(this.f_97735_ - 13, this.f_97736_ + 58, 49, 27);
        this.mobsInvButton = new InventoryButton(this.f_97735_ - 29, this.f_97736_ + 26, 49, 14);
        this.renderTabButtons();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            TravelersCompassItem compassStack;
            ItemStack stack = player.m_21205_();
            Item item = stack.m_41720_();
            if (item instanceof TravelersCompassItem && (compassStack = (TravelersCompassItem)item).configMode(stack)) {
                this.removeSearchButtons();
                this.addConfigButtons();
            }
            if ((item = stack.m_41720_()) instanceof TravelersCompassItem && !(compassStack = (TravelersCompassItem)item).configMode(stack)) {
                this.removeConfigButtons();
                this.addSearchButtons();
            }
        }
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.updateTooltips();
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        ItemStack stack;
        Object object;
        this.m_280273_(guiGraphics);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (object = (stack = player.m_21205_()).m_41720_()) instanceof TravelersCompassItem) {
            TravelersCompassItem compassStack = (TravelersCompassItem)((Object)object);
            if (compassStack.configMode(player.m_21205_())) {
                guiGraphics.m_280218_(TEXTURE_2, this.f_97735_ - 18, this.f_97736_ - 35, 0, 0, this.f_97726_ + 18, this.f_97727_ + 35);
            } else {
                guiGraphics.m_280218_(TEXTURE_1, this.f_97735_ - 18, this.f_97736_ - 35, 0, 0, this.f_97726_ + 18, this.f_97727_ + 35);
            }
            object = compassStack.favoriteSlots(stack).iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                int j = i > 2 ? 1 : 0;
                j = i > 5 ? 2 : j;
                int c = i > 2 ? i - 3 : i;
                c = i > 5 ? i - 6 : c;
                guiGraphics.m_280218_(WIDGETS, this.f_97735_ + 71 + c * 18, this.f_97736_ + 13 + j * 18, 0, 158, 18, 18);
            }
        }
    }

    public void renderTabButtons() {
        this.statusButton = new TabButton(this.f_97735_ - 18, this.f_97736_ + 79, 23, 22, 3, configButton -> {});
        this.searchButton = new TabButton(this.f_97735_ + 129, this.f_97736_ + 14, 26, 24, 0, configButton -> {
            TravelersCompassItem compassStack;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            Item patt7527$temp = stack.m_41720_();
            if (patt7527$temp instanceof TravelersCompassItem && !(compassStack = (TravelersCompassItem)patt7527$temp).configMode(stack)) {
                return;
            }
            Item patt7683$temp = stack.m_41720_();
            if (patt7683$temp instanceof TravelersCompassItem) {
                compassStack = (TravelersCompassItem)patt7683$temp;
                this.removeConfigButtons();
                this.addSearchButtons();
                NetworkHandler.CHANNEL.sendToServer((Object)new SearchButtonPacket(5));
                compassStack.setConfigMode(stack, false);
            }
        });
        this.configButton = new TabButton(this.f_97735_ + 129, this.f_97736_ + 43, 26, 24, 1, configButton -> {
            TravelersCompassItem compassStack;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack stack = player.m_21205_();
            Item patt8310$temp = stack.m_41720_();
            if (patt8310$temp instanceof TravelersCompassItem && (compassStack = (TravelersCompassItem)patt8310$temp).configMode(stack)) {
                return;
            }
            Item patt8465$temp = stack.m_41720_();
            if (patt8465$temp instanceof TravelersCompassItem) {
                compassStack = (TravelersCompassItem)patt8465$temp;
                this.removeSearchButtons();
                this.addConfigButtons();
                NetworkHandler.CHANNEL.sendToServer((Object)new SearchButtonPacket(4));
                compassStack.setConfigMode(stack, true);
            }
        });
        this.searchButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.searching")));
        this.configButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.config")));
        this.m_142416_((GuiEventListener)this.statusButton);
        this.m_142416_((GuiEventListener)this.searchButton);
        this.m_142416_((GuiEventListener)this.configButton);
    }

    private void updateTooltips() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || this.f_96541_ == null) {
            return;
        }
        ItemStack stack = player.m_21205_();
        boolean shiftKeyPressed = GLFW.glfwGetKey((long)this.f_96541_.m_91268_().m_85439_(), (int)340) == 1 || GLFW.glfwGetKey((long)this.f_96541_.m_91268_().m_85439_(), (int)344) == 1;
        Item item = stack.m_41720_();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassStack = (TravelersCompassItem)item;
            CompassContainer compassContainer = CompassContainer.container(stack);
            boolean fluids = compassStack.isSearchingFluids(stack);
            boolean droppedItems = compassStack.isSearchingItemEntities(stack);
            boolean spawners = compassStack.isSearchingSpawners(stack);
            boolean invS = compassStack.isSearchingEntitiesInv(stack);
            boolean drops = compassStack.isSearchingDrops(stack);
            boolean pause = compassStack.isPaused(stack);
            boolean blocks = compassStack.isSearchingBlocks(stack);
            boolean containers = compassStack.isSearchingContainers(stack);
            boolean priorityMode = compassStack.priorityMode(stack);
            boolean labels = compassStack.showLabels(stack);
            boolean mobs = compassStack.isSearchingMobs(stack);
            boolean sound = compassStack.sound(stack);
            boolean lazyMode = compassStack.isLazyModeOn(stack);
            Object blocksTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.block_button").getString();
            if (shiftKeyPressed) {
                blocksTooltip = (String)blocksTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.blocks.info").getString();
            }
            blocksTooltip = (String)blocksTooltip + (blocks ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object containersTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.container_button").getString();
            if (shiftKeyPressed) {
                containersTooltip = (String)containersTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.containers.info").getString();
            }
            containersTooltip = (String)containersTooltip + (containers ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object mobsTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.mob_button").getString();
            if (shiftKeyPressed) {
                mobsTooltip = (String)mobsTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.mobs.info").getString();
            }
            mobsTooltip = (String)mobsTooltip + (mobs ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object fluidTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.fluid_button").getString();
            if (shiftKeyPressed) {
                fluidTooltip = (String)fluidTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.fluids.info").getString();
            }
            fluidTooltip = (String)fluidTooltip + (fluids ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object itemEntityTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.item_entity_button").getString();
            if (shiftKeyPressed) {
                itemEntityTooltip = (String)itemEntityTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.item_entity.info").getString();
            }
            itemEntityTooltip = (String)itemEntityTooltip + (droppedItems ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object spawnerTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.spawner_button").getString();
            if (shiftKeyPressed) {
                spawnerTooltip = (String)spawnerTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.spawners.info").getString();
            }
            spawnerTooltip = (String)spawnerTooltip + (spawners ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object mobsInvToolTip = Component.m_237115_((String)"options.travelerscompass.tooltip.mobs_inv_button").getString();
            if (shiftKeyPressed) {
                mobsInvToolTip = (String)mobsInvToolTip + Component.m_237115_((String)"options.travelerscompass.tooltip.mobs_inv.info").getString();
            }
            mobsInvToolTip = (String)mobsInvToolTip + (invS ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object dropsToolTip = Component.m_237115_((String)"options.travelerscompass.tooltip.mobs_drop_button").getString();
            if (shiftKeyPressed) {
                dropsToolTip = (String)dropsToolTip + Component.m_237115_((String)"options.travelerscompass.tooltip.drops.info").getString();
            }
            dropsToolTip = (String)dropsToolTip + (drops ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object pauseToolTip = pause ? Component.m_237115_((String)"options.travelerscompass.tooltip.play").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.pause_1").getString();
            pauseToolTip = (String)pauseToolTip + (pause ? Component.m_237115_((String)"options.travelerscompass.tooltip.play_more").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.pause_more").getString());
            Object priorityTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.priority_button").getString();
            priorityTooltip = (String)priorityTooltip + (priorityMode ? Component.m_237115_((String)"options.travelerscompass.tooltip.priority_button_1").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.priority_button_2").getString());
            if (shiftKeyPressed) {
                priorityTooltip = (String)priorityTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.priority_button_3").getString();
            }
            Object labelTooltip = labels ? Component.m_237115_((String)"options.travelerscompass.tooltip.label_button_1").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.label_button_2").getString();
            labelTooltip = (String)labelTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.label_button_3").getString();
            Object resetTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.full_reset_button").getString();
            resetTooltip = (String)resetTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.full_reset_button_1").getString();
            Object blockSearchRadiusTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.block_search_radius").getString();
            blockSearchRadiusTooltip = shiftKeyPressed ? (String)blockSearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.block_search_radius_1").getString() : (String)blockSearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            blockSearchRadiusTooltip = (String)blockSearchRadiusTooltip + Component.m_237110_((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.blockSearchRadius(stack)}).getString();
            Object containerSearchRadiusTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.container_search_radius").getString();
            containerSearchRadiusTooltip = shiftKeyPressed ? (String)containerSearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.container_search_radius_1").getString() : (String)containerSearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            containerSearchRadiusTooltip = (String)containerSearchRadiusTooltip + Component.m_237110_((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.containerSearchRadius(stack)}).getString();
            Object wideSearchTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.wide_search_button").getString();
            wideSearchTooltip = (String)wideSearchTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.wide_search_button_1").getString();
            Object entitySearchRadiusTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.entity_search_radius").getString();
            entitySearchRadiusTooltip = shiftKeyPressed ? (String)entitySearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.entity_search_radius_1").getString() : (String)entitySearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            entitySearchRadiusTooltip = (String)entitySearchRadiusTooltip + Component.m_237110_((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.entitySearchRadius(stack)}).getString();
            Object wideSearchRadiusTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.wide_search_radius").getString();
            wideSearchRadiusTooltip = shiftKeyPressed ? (String)wideSearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.wide_search_radius_1").getString() : (String)wideSearchRadiusTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.shift_to_decrease").getString();
            wideSearchRadiusTooltip = (String)wideSearchRadiusTooltip + Component.m_237110_((String)"options.travelerscompass.tooltip.current_value", (Object[])new Object[]{compassStack.wideSearchRadius(stack)}).getString();
            Object soundButtonTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.sound_switch").getString();
            if (shiftKeyPressed) {
                soundButtonTooltip = (String)soundButtonTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.sound_switch_1").getString();
            }
            soundButtonTooltip = (String)soundButtonTooltip + (sound ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString());
            Object lazyButtonTooltip = Component.m_237115_((String)"options.travelerscompass.tooltip.lazy_mode").getString();
            if (shiftKeyPressed) {
                lazyButtonTooltip = (String)lazyButtonTooltip + Component.m_237115_((String)"options.travelerscompass.tooltip.lazy_mode_1").getString();
            }
            lazyButtonTooltip = (String)lazyButtonTooltip + ((Boolean)TCConfig.forcedLazySearchMode.get() != false ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled_config").getString() : (lazyMode ? Component.m_237115_((String)"options.travelerscompass.tooltip.enabled").getString() : Component.m_237115_((String)"options.travelerscompass.tooltip.disabled").getString()));
            this.fluidButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)fluidTooltip)));
            this.itemEntityButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)itemEntityTooltip)));
            this.spawnerButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)spawnerTooltip)));
            this.mobsInvButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)mobsInvToolTip)));
            this.dropsButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)dropsToolTip)));
            this.pauseButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)pauseToolTip)));
            this.blockButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)blocksTooltip)));
            this.mobButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)mobsTooltip)));
            this.containerButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)containersTooltip)));
            this.blocksDistanceButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)blockSearchRadiusTooltip)));
            this.mobsDistanceButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)entitySearchRadiusTooltip)));
            this.containersDistanceButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)containerSearchRadiusTooltip)));
            this.wideDistanceButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)wideSearchRadiusTooltip)));
            this.wideSearchButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)wideSearchTooltip)));
            this.prioritySwitch.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)priorityTooltip)));
            this.labelSwitch.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)labelTooltip)));
            this.fullResetButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)resetTooltip)));
            this.soundButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)soundButtonTooltip)));
            this.lazyButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)lazyButtonTooltip)));
            this.checkDisabledButtons();
        }
    }

    private void checkDisabledButtons() {
        if (!((Boolean)TCConfig.enableMobSearch.get()).booleanValue()) {
            this.mobButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableBlockSearch.get()).booleanValue()) {
            this.blockButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableContainerSearch.get()).booleanValue()) {
            this.containerButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableWiderSearch.get()).booleanValue()) {
            this.wideSearchButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableItemEntitiesSearch.get()).booleanValue()) {
            this.itemEntityButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableFluidSearch.get()).booleanValue()) {
            this.fluidButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableSpawnerSearch.get()).booleanValue()) {
            this.spawnerButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableDropSearch.get()).booleanValue()) {
            this.dropsButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
        if (!((Boolean)TCConfig.enableMobsInventorySearch.get()).booleanValue()) {
            this.mobsInvButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"options.travelerscompass.tooltip.disabled_config")));
        }
    }

    private void addConfigButtons() {
        this.m_142416_((GuiEventListener)this.blocksDistanceButton);
        this.m_142416_((GuiEventListener)this.mobsDistanceButton);
        this.m_142416_((GuiEventListener)this.containersDistanceButton);
        this.m_142416_((GuiEventListener)this.wideDistanceButton);
        this.m_142416_((GuiEventListener)this.prioritySwitch);
        this.m_142416_((GuiEventListener)this.labelSwitch);
        this.m_142416_((GuiEventListener)this.fullResetButton);
        this.m_142416_((GuiEventListener)this.hudButton);
        this.m_142416_((GuiEventListener)this.lazyButton);
        this.m_142416_((GuiEventListener)this.soundButton);
    }

    private void removeConfigButtons() {
        this.m_169411_((GuiEventListener)this.blocksDistanceButton);
        this.m_169411_((GuiEventListener)this.mobsDistanceButton);
        this.m_169411_((GuiEventListener)this.containersDistanceButton);
        this.m_169411_((GuiEventListener)this.wideDistanceButton);
        this.m_169411_((GuiEventListener)this.prioritySwitch);
        this.m_169411_((GuiEventListener)this.labelSwitch);
        this.m_169411_((GuiEventListener)this.fullResetButton);
        this.m_169411_((GuiEventListener)this.hudButton);
        this.m_169411_((GuiEventListener)this.lazyButton);
        this.m_169411_((GuiEventListener)this.soundButton);
    }

    private void addSearchButtons() {
        this.m_142416_((GuiEventListener)this.villagerButton);
        this.m_142416_((GuiEventListener)this.itemEntityButton);
        this.m_142416_((GuiEventListener)this.fluidButton);
        this.m_142416_((GuiEventListener)this.spawnerButton);
        this.m_142416_((GuiEventListener)this.infoButton);
        this.m_142416_((GuiEventListener)this.mobsInvButton);
        this.m_142416_((GuiEventListener)this.dropsButton);
        this.m_142416_((GuiEventListener)this.pauseButton);
        this.m_142416_((GuiEventListener)this.blockButton);
        this.m_142416_((GuiEventListener)this.mobButton);
        this.m_142416_((GuiEventListener)this.containerButton);
        this.m_142416_((GuiEventListener)this.wideSearchButton);
    }

    private void removeSearchButtons() {
        this.m_169411_((GuiEventListener)this.villagerButton);
        this.m_169411_((GuiEventListener)this.itemEntityButton);
        this.m_169411_((GuiEventListener)this.fluidButton);
        this.m_169411_((GuiEventListener)this.spawnerButton);
        this.m_169411_((GuiEventListener)this.infoButton);
        this.m_169411_((GuiEventListener)this.mobsInvButton);
        this.m_169411_((GuiEventListener)this.dropsButton);
        this.m_169411_((GuiEventListener)this.pauseButton);
        this.m_169411_((GuiEventListener)this.blockButton);
        this.m_169411_((GuiEventListener)this.mobButton);
        this.m_169411_((GuiEventListener)this.containerButton);
        this.m_169411_((GuiEventListener)this.wideSearchButton);
    }
}

