/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.container;

import com.nine.travelerscompass.common.item.TravelersCompassItem;
import com.nine.travelerscompass.common.utils.ConfigUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CompassContainer
implements Container {
    private final ItemStack containerStack;
    private final NonNullList<ItemStack> inventory;
    private final int maxStackSize;

    private CompassContainer(ItemStack containerStack, int inventorySize, int maxStackSize) {
        this.containerStack = containerStack;
        this.maxStackSize = maxStackSize;
        this.inventory = NonNullList.m_122780_((int)inventorySize, (Object)ItemStack.f_41583_);
        this.load(containerStack.m_41784_());
    }

    public ArrayList<Item> getFavoriteList(TravelersCompassItem containerStack, ItemStack stack) {
        ArrayList<Integer> list1 = containerStack.favoriteSlots(stack);
        ArrayList<Item> list2 = new ArrayList<Item>();
        for (int i : list1) {
            Item item = this.m_8020_(i).m_41720_();
            if (item instanceof AirItem) continue;
            list2.add(item);
        }
        return list2;
    }

    public static CompassContainer container(ItemStack containerHolder) {
        return new CompassContainer(containerHolder, 9, 1);
    }

    public List<Item> getList() {
        ArrayList<Item> list = new ArrayList<Item>();
        for (int i = 0; i < 9; ++i) {
            Item item = this.m_8020_(i).m_41720_();
            if (item instanceof AirItem) continue;
            list.add(item);
        }
        return list;
    }

    public boolean hasAny(ItemStack itemStack) {
        for (int i = 0; i < 9; ++i) {
            if (!itemStack.m_150930_(this.m_8020_(i).m_41720_())) continue;
            return true;
        }
        return false;
    }

    public int getFirstEmptySlot() {
        for (int i = 0; i < 9; ++i) {
            if (!this.m_8020_(i).m_150930_(ItemStack.f_41583_.m_41720_())) continue;
            return i;
        }
        return 0;
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public void load(CompoundTag tag) {
        ListTag items = tag.m_128437_("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag item = items.m_128728_(i);
            int slot = item.m_128451_("Slot");
            if (slot >= this.m_6643_()) continue;
            this.inventory.set(slot, (Object)ItemStack.m_41712_((CompoundTag)item));
        }
    }

    public void save(CompoundTag tag) {
        ListTag items = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            CompoundTag item = new CompoundTag();
            item.m_128405_("Slot", i);
            this.m_8020_(i).m_41739_(item);
            items.add((Object)item);
        }
        tag.m_128365_("ItemInventory", (Tag)items);
    }

    public ItemStack m_7407_(int index, int size) {
        ItemStack stack = this.m_8020_(index);
        if (!stack.m_41619_()) {
            if (stack.m_41613_() > size) {
                stack = stack.m_41620_(size);
                this.m_6596_();
            } else {
                this.m_6836_(index, ItemStack.f_41583_);
            }
        }
        stack.m_41764_(0);
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.m_8020_(index);
        this.m_6836_(index, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (stack.m_41720_() instanceof TravelersCompassItem) {
            return;
        }
        if (stack == ItemStack.f_41583_) {
            this.inventory.set(index, (Object)stack);
            if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }
        if (!ConfigUtils.isAllowedToSearch(stack)) {
            return;
        }
        this.inventory.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public int m_6893_() {
        return this.maxStackSize;
    }

    public void m_6596_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_() || this.m_8020_(i).m_41613_() != 0) continue;
            this.inventory.set(i, (Object)ItemStack.f_41583_);
        }
        this.save(this.containerStack.m_41783_());
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public void m_5856_(Player player) {
    }

    public void m_5785_(Player player) {
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.f_41583_);
        }
    }

    public boolean m_7983_() {
        for (ItemStack stack : this.inventory) {
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }
}

