/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.item;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.container.CompassContainer;
import com.nine.travelerscompass.common.container.menu.CompassMenu;
import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.utils.ConfigUtils;
import com.nine.travelerscompass.common.utils.PositionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TravelersCompassItem
extends Item {
    public TravelersCompassItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        CompassContainer compassContainer = CompassContainer.container(stack);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        if (player.m_6144_()) {
            ItemStack clickedStack;
            Vec3 lookVector = player.m_20154_();
            Vec3 eyePosition = player.m_20299_(1.0f);
            Vec3 traceEnd = eyePosition.m_82520_(lookVector.f_82479_ * 5.0, lookVector.f_82480_ * 5.0, lookVector.f_82481_ * 5.0);
            BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePosition, traceEnd, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            BlockPos blockPos = hitResult.m_82425_();
            if (!level.f_46443_ && !compassContainer.hasAny(clickedStack = level.m_8055_(blockPos).m_60734_().m_5456_().m_7968_()) && ConfigUtils.isAllowedToSearch(clickedStack)) {
                compassContainer.m_6836_(compassContainer.getFirstEmptySlot(), clickedStack);
                level.m_5594_(null, player.m_20097_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
            }
        }
        if (!level.f_46443_) {
            this.checkForbiddenItems(compassContainer);
            this.checkForbiddenOptions(stack);
            player.m_5893_(new MenuProvider(){

                public AbstractContainerMenu m_7208_(int id, @NotNull Inventory playerInventory, @NotNull Player player) {
                    return new CompassMenu(id, playerInventory, CompassContainer.container(stack));
                }

                @NotNull
                public Component m_5446_() {
                    return stack.m_41786_();
                }
            });
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity living, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_()) {
            ItemStack eggStack;
            Mob mob;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (player.m_6144_() && living instanceof Mob && SpawnEggItem.m_43213_((EntityType)(mob = (Mob)living).m_6095_()) != null && !compassContainer.hasAny(eggStack = Objects.requireNonNull(SpawnEggItem.m_43213_((EntityType)mob.m_6095_())).m_7968_()) && ConfigUtils.isAllowedToSearch(eggStack) && ConfigUtils.isAllowedToSearch(living)) {
                compassContainer.m_6836_(compassContainer.getFirstEmptySlot(), eggStack);
                player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public void updateBlockPosition(Level level, Entity entity, ItemStack stack, boolean wideSearch) {
        CompassContainer compassContainer = CompassContainer.container(stack);
        Item item = stack.m_41720_();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)item;
            if (compassContainer.m_7983_()) {
                compassItem.addBlockPositionTags(null, stack, level, entity);
                return;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!TravelersCompassItem.canSearch(player)) {
                    return;
                }
                compassItem.addBlockPositionTags(PositionUtils.getNearestLocation(level, entity, compassItem, compassContainer, stack, wideSearch), stack, level, entity);
            }
        }
    }

    @Nullable
    public static BlockPos getFoundPosition(@NotNull ItemStack stack) {
        if (!stack.m_41784_().m_128471_("found")) {
            return null;
        }
        Item item = stack.m_41720_();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem compassItem = (TravelersCompassItem)item;
            return NbtUtils.m_129239_((CompoundTag)stack.m_41698_("foundPos"));
        }
        return NbtUtils.m_129239_((CompoundTag)stack.m_41698_("foundPos"));
    }

    public void addBlockPositionTags(PositionUtils.LocationData data, ItemStack stack, Level level, Entity entity) {
        boolean shouldPing = false;
        CompoundTag compoundTag = stack.m_41784_();
        if (data == null || data.getBlockPos() == null) {
            if (compoundTag.m_128471_("found")) {
                compoundTag.m_128379_("found", false);
            }
            return;
        }
        BlockPos blockPos = data.getBlockPos();
        if (!compoundTag.m_128471_("found")) {
            shouldPing = true;
            compoundTag.m_128379_("found", true);
        }
        if (this.sound(stack)) {
            if (!Objects.equals(this.foundTarget(stack), data.getName())) {
                shouldPing = true;
            }
            if (shouldPing) {
                if (data.hasAnyFavorite()) {
                    level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.3f, 0.3f);
                }
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 0.44f + level.f_46441_.m_188501_() / 10.0f);
                level.m_5594_(null, entity.m_20183_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, 1.0f);
            }
        }
        if (data.getName() != null) {
            this.writeFoundTarget(stack, data.getName());
        } else {
            this.writeFoundTarget(stack, "Null");
        }
        compoundTag.m_128365_("foundPos", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
    }

    public static void xpDrain(Player player) {
        if (!player.m_7500_() && !player.m_5833_()) {
            int currentExp = player.f_36079_;
            if (currentExp - (Integer)TCConfig.xpCost.get() > 0) {
                player.m_6756_(-((Integer)TCConfig.xpCost.get()).intValue());
            } else {
                player.f_36078_ = 0;
                player.f_36080_ = 0.0f;
                player.f_36079_ = 0;
            }
        }
    }

    public static boolean canSearch(Player player) {
        if (!((Boolean)TCConfig.xpDrain.get()).booleanValue()) {
            return true;
        }
        if (!player.m_7500_() && !player.m_5833_()) {
            int currentExp = player.f_36079_;
            return currentExp > 0;
        }
        return true;
    }

    public void checkForbiddenItems(CompassContainer compassContainer) {
        for (int index = 0; index < 9; ++index) {
            if (ConfigUtils.isAllowedToSearch(compassContainer.m_8020_(index))) continue;
            compassContainer.m_7407_(index, 1);
        }
    }

    public void checkForbiddenOptions(ItemStack stack) {
        if (this.isSearchingEntitiesInv(stack) && !((Boolean)TCConfig.enableMobsInventorySearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
        }
        if (this.isSearchingBlocks(stack) && !((Boolean)TCConfig.enableBlockSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
        }
        if (this.isSearchingFluids(stack) && !((Boolean)TCConfig.enableFluidSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_FLUIDS);
        }
        if (this.isSearchingItemEntities(stack) && !((Boolean)TCConfig.enableItemEntitiesSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
        }
        if (this.isSearchingVillagers(stack) && !((Boolean)TCConfig.enableVillagersSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS);
        }
        if (this.isSearchingDrops(stack) && !((Boolean)TCConfig.enableDropSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
        }
        if (this.isSearchingMobs(stack) && !((Boolean)TCConfig.enableMobSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_MOBS);
        }
        if (this.isSearchingContainers(stack) && !((Boolean)TCConfig.enableContainerSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
        }
        if (this.isSearchingMobsInv(stack) && !((Boolean)TCConfig.enableMobsInventorySearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_MOBS_INV);
        }
        if (this.isSearchingSpawners(stack) && !((Boolean)TCConfig.enableSpawnerSearch.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.SEARCHING_SPAWNERS);
        }
        if (!this.isLazyModeOn(stack) && ((Boolean)TCConfig.forcedLazySearchMode.get()).booleanValue()) {
            this.writeCompassData(stack, CompassData.LAZY_MODE);
        }
        if ((this.hudMode(stack) || this.hudModeRequiresHeld(stack)) && !((Boolean)TCConfig.enableHud.get()).booleanValue()) {
            this.writeCompassData(stack, this.hudMode(stack) ? CompassData.HUD_SHOW : CompassData.HUD_SHOW_HAND);
        }
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level pLevel, @NotNull Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockPos targetBlockPos = TravelersCompassItem.getFoundPosition(stack);
            boolean lazyCheck = true;
            CompassContainer compassContainer = CompassContainer.container(stack);
            if (compassContainer.m_7983_() && targetBlockPos == null) {
                if (this.positionRelativeToTarget(stack) != 6) {
                    this.setPositionRelativeToTarget(stack, 6);
                }
                return;
            }
            if (player.f_19797_ % 20 == 0) {
                this.checkPossibleResourceRecovery(player, stack, compassContainer);
            }
            if (!TravelersCompassItem.canSearch(player)) {
                if (this.positionRelativeToTarget(stack) != 5) {
                    this.setPositionRelativeToTarget(stack, 5);
                }
                return;
            }
            int lazyBonus = 0;
            if (this.isLazyModeOn(stack) && targetBlockPos != null) {
                if (Math.sqrt(targetBlockPos.m_123331_((Vec3i)player.m_20183_())) < 15.0) {
                    lazyCheck = false;
                }
                lazyBonus = (Integer)TCConfig.searchRate.get() * 2 * (1500 / (int)Math.sqrt(targetBlockPos.m_123331_((Vec3i)player.m_20183_())));
            }
            if (lazyCheck && (player.f_19797_ % ((Integer)TCConfig.searchRate.get() + lazyBonus) == 0 && !pLevel.f_46443_ && !this.isPaused(stack) || this.wideSearchSignal(stack))) {
                this.updateBlockPosition(pLevel, pEntity, stack, this.wideSearchSignal(stack));
                if (this.wideSearchSignal(stack)) {
                    this.writeCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
                }
            }
            if (((Boolean)TCConfig.xpDrain.get()).booleanValue() && player.f_19797_ % (Integer)TCConfig.xpDrainRate.get() == 0 && !this.isPaused(stack) && TravelersCompassItem.getFoundPosition(stack) != null) {
                TravelersCompassItem.xpDrain(player);
            }
            if (player.f_19797_ % 40 == 0) {
                if (targetBlockPos == null) {
                    if (this.positionRelativeToTarget(stack) != 4) {
                        this.setPositionRelativeToTarget(stack, 4);
                    }
                    return;
                }
                BlockPos userPos = player.m_20097_();
                double livingY = userPos.m_123342_();
                double targetY = Objects.requireNonNull(targetBlockPos).m_123342_();
                double point1 = targetY - livingY;
                if (this.showLabels(stack) && this.positionRelativeToTarget(stack) != -2) {
                    this.setPositionRelativeToTarget(stack, -2);
                }
                if (this.showLabels(stack)) {
                    return;
                }
                if (targetY == livingY || point1 <= 2.0 && point1 >= 1.0 && this.positionRelativeToTarget(stack) != 3) {
                    this.setPositionRelativeToTarget(stack, 3);
                } else if (!(!(targetY > livingY) || point1 <= 2.0 && point1 >= 1.0 || this.positionRelativeToTarget(stack) == 2)) {
                    this.setPositionRelativeToTarget(stack, 2);
                } else if (targetY < livingY && this.positionRelativeToTarget(stack) != 1) {
                    this.setPositionRelativeToTarget(stack, 1);
                }
            }
        }
    }

    private void checkPossibleResourceRecovery(Player player, ItemStack stack, CompassContainer compassContainer) {
        List<Item> list = compassContainer.getList();
        int k = 0;
        for (int i = 0; i < 9; ++i) {
            Item item = compassContainer.m_8020_(i).m_41720_();
            if (i == 4 && item.equals(Items.f_42522_)) {
                ++k;
            }
            if (i == 7 && item.equals(Items.f_42790_)) {
                ++k;
                continue;
            }
            if (i == 7 || i == 4 || !item.equals(Items.f_42416_)) continue;
            ++k;
        }
        if (k == 9) {
            for (Item item : list) {
                ItemEntity itementity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), item.m_7968_());
                player.m_9236_().m_7967_((Entity)itementity);
            }
            stack.m_41774_(1);
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof CompassMenu) {
                CompassMenu menu = (CompassMenu)abstractContainerMenu;
                player.m_6915_();
            }
        }
    }

    public boolean isSearchingVillagers(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS);
    }

    public boolean isSearchingItemEntities(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
    }

    public boolean isSearchingVillagersGoods(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS_GOODS);
    }

    public boolean isSearchingVillagersCost(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_VILLAGERS_COST);
    }

    public boolean isSearchingMobsInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MOBS_INV);
    }

    public boolean isSearchingMinecartsInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MINECARTS_INV);
    }

    public boolean isSearchingPlayersInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_PLAYERS_INV);
    }

    public boolean isSearchingFluids(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_FLUIDS);
    }

    public boolean isSearchingSpawners(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_SPAWNERS);
    }

    public boolean isSearchingEntitiesInv(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
    }

    public boolean isSearchingContainers(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_CONTAINERS);
    }

    public boolean isSearchingDrops(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
    }

    public boolean isSearchingBlocks(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_BLOCKS);
    }

    public boolean isSearchingMobs(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SEARCHING_MOBS);
    }

    public boolean isLazyModeOn(ItemStack stack) {
        return this.getCompassData(stack, CompassData.LAZY_MODE);
    }

    public boolean sound(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SOUND);
    }

    public boolean isPaused(ItemStack stack) {
        return this.getCompassData(stack, CompassData.PAUSED);
    }

    public boolean wideSearchSignal(ItemStack stack) {
        return this.getCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
    }

    public boolean showLabels(ItemStack stack) {
        return this.getCompassData(stack, CompassData.SHOW_LABELS);
    }

    public boolean priorityMode(ItemStack stack) {
        return !this.getCompassData(stack, CompassData.PRIORITY_MODE);
    }

    public boolean hudMode(ItemStack stack) {
        return this.getCompassData(stack, CompassData.HUD_SHOW);
    }

    public boolean hudModeRequiresHeld(ItemStack stack) {
        return this.getCompassData(stack, CompassData.HUD_SHOW_HAND);
    }

    public boolean getCompassData(ItemStack stack, CompassData mode) {
        int id = mode.getID();
        ArrayList<Integer> modeValues = this.integerArrayList(stack, "compass_data");
        return modeValues.contains(id);
    }

    public void writeCompassData(ItemStack stack, CompassData mode) {
        int id = mode.getID();
        this.putIntArray(stack, id, "compass_data");
    }

    public void markFavoriteItem(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_("favorite", mode);
    }

    public boolean hasFavoriteItem(ItemStack stack) {
        return stack.m_41784_().m_128471_("favorite");
    }

    public void addFavoriteSlot(ItemStack stack, int slot) {
        this.putIntArray(stack, slot, "favoriteSlots");
    }

    public ArrayList<Integer> favoriteSlots(ItemStack stack) {
        return this.integerArrayList(stack, "favoriteSlots");
    }

    public ArrayList<Integer> selectedModes(ItemStack stack) {
        return this.integerArrayList(stack, "compass_data");
    }

    public void setConfigMode(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_("configMode", mode);
    }

    public boolean configMode(ItemStack stack) {
        return stack.m_41784_().m_128471_("configMode");
    }

    public void writeFoundTarget(ItemStack stack, String target) {
        stack.m_41784_().m_128359_("targetData", target);
    }

    public String foundTarget(ItemStack stack) {
        return stack.m_41784_().m_128461_("targetData");
    }

    public void setPositionRelativeToTarget(ItemStack stack, int pos) {
        stack.m_41784_().m_128405_("pos_to_target", pos);
    }

    public int positionRelativeToTarget(ItemStack stack) {
        return stack.m_41784_().m_128451_("pos_to_target");
    }

    public int blockSearchRadius(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("block_search_radius", 3)) {
            return tag.m_128451_("block_search_radius");
        }
        return (int)((float)((Integer)TCConfig.blockSearchRadius.get()).intValue() * 0.5f);
    }

    public void setBlockSearchRadius(ItemStack stack, int radius) {
        stack.m_41784_().m_128405_("block_search_radius", radius);
    }

    public int containerSearchRadius(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("container_search_radius", 3)) {
            return tag.m_128451_("container_search_radius");
        }
        return (int)((float)((Integer)TCConfig.containerSearchRadius.get()).intValue() * 0.5f);
    }

    public void setContainerSearchRadius(ItemStack stack, int radius) {
        stack.m_41784_().m_128405_("container_search_radius", radius);
    }

    public int entitySearchRadius(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("entity_search_radius", 3)) {
            return tag.m_128451_("entity_search_radius");
        }
        return (int)((float)((Integer)TCConfig.entitySearchRadius.get()).intValue() * 0.5f);
    }

    public void setEntitySearchRadius(ItemStack stack, int radius) {
        stack.m_41784_().m_128405_("entity_search_radius", radius);
    }

    public int wideSearchRadius(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("wide_search_radius", 3)) {
            return tag.m_128451_("wide_search_radius");
        }
        return (int)((float)((Integer)TCConfig.wideSearchRadius.get()).intValue() * 0.5f);
    }

    public void setWideSearchRadius(ItemStack stack, int radius) {
        stack.m_41784_().m_128405_("wide_search_radius", radius);
    }

    public void setHudWithChatMode(ItemStack stack, boolean mode) {
        stack.m_41784_().m_128379_("hud_chat", mode);
    }

    public boolean hudWithChatMode(ItemStack stack) {
        return stack.m_41784_().m_128471_("hud_chat");
    }

    public void setHudPos(ItemStack stack, int x, int y) {
        int[] data = new int[4];
        data[0] = x;
        data[1] = y;
        if (stack.m_41720_() instanceof TravelersCompassItem) {
            data[2] = this.getHudAlign(stack);
            data[3] = this.getHudType(stack);
        }
        stack.m_41784_().m_128385_("hud_data", data);
    }

    public void setHudAlign(ItemStack stack, int type) {
        int[] data = new int[4];
        data[2] = type;
        data[0] = this.getXHudPos(stack);
        data[1] = this.getYHudPos(stack);
        data[3] = this.getHudType(stack);
        stack.m_41784_().m_128385_("hud_data", data);
    }

    public void setHudType(ItemStack stack, int type) {
        int[] data = new int[4];
        data[2] = this.getHudAlign(stack);
        data[0] = this.getXHudPos(stack);
        data[1] = this.getYHudPos(stack);
        data[3] = type;
        stack.m_41784_().m_128385_("hud_data", data);
    }

    public int getHudAlign(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("hud_data", 11)) {
            return stack.m_41784_().m_128465_("hud_data")[2];
        }
        return 0;
    }

    public int getHudType(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("hud_data", 11)) {
            return stack.m_41784_().m_128465_("hud_data")[3];
        }
        return 0;
    }

    public int getXHudPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("hud_data", 11)) {
            return stack.m_41784_().m_128465_("hud_data")[0];
        }
        return 0;
    }

    public int getYHudPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("hud_data", 11)) {
            return stack.m_41784_().m_128465_("hud_data")[1];
        }
        return 0;
    }

    public void putIntArray(ItemStack stack, int slot, String tag) {
        int[] existingSlots = stack.m_41784_().m_128465_(tag);
        ArrayList<Integer> slotsList = new ArrayList<Integer>();
        for (int existingSlot : existingSlots) {
            slotsList.add(existingSlot);
        }
        if (slotsList.contains(slot)) {
            slotsList.remove((Object)slot);
        } else {
            slotsList.add(slot);
        }
        int[] newSlots = new int[slotsList.size()];
        for (int i = 0; i < slotsList.size(); ++i) {
            newSlots[i] = (Integer)slotsList.get(i);
        }
        stack.m_41784_().m_128385_(tag, newSlots);
    }

    public ArrayList<Integer> integerArrayList(ItemStack stack, String tag) {
        int[] slotsArray = stack.m_41784_().m_128465_(tag);
        ArrayList<Integer> slotsList = new ArrayList<Integer>();
        for (int slot : slotsArray) {
            slotsList.add(slot);
        }
        return slotsList;
    }
}

