/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.TCConfig;
import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class ConfigButtonPacket {
    private final int ID;
    private final boolean shiftPressed;
    private final boolean controlPressed;

    public ConfigButtonPacket(int value, boolean controlPressed, boolean shiftPressed) {
        this.ID = value;
        this.controlPressed = controlPressed;
        this.shiftPressed = shiftPressed;
    }

    public ConfigButtonPacket(int value) {
        this.ID = value;
        this.controlPressed = false;
        this.shiftPressed = false;
    }

    public ConfigButtonPacket(FriendlyByteBuf buf) {
        this.ID = buf.m_130242_();
        this.controlPressed = buf.readBoolean();
        this.shiftPressed = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.ID);
        buf.writeBoolean(this.controlPressed);
        buf.writeBoolean(this.shiftPressed);
    }

    /*
     * Unable to fully structure code
     */
    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        block35: {
            player = ctx.get().getSender();
            stack = ((Player)Objects.requireNonNull(player)).m_21205_();
            var5_4 = stack.m_41720_();
            if (!(var5_4 instanceof TravelersCompassItem)) break block35;
            travelersCompassItem = (TravelersCompassItem)var5_4;
            controlPressed = this.controlPressed;
            shiftPressed = this.shiftPressed;
            amount = (shiftPressed != false ? -1 : 1) * (controlPressed != false ? 5 : 1);
            switch (this.ID) {
                case 0: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MOBS);
                    break;
                }
                case 1: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
                    break;
                }
                case 2: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
                    break;
                }
                case 3: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_FLUIDS);
                    break;
                }
                case 4: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS);
                    break;
                }
                case 5: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_SPAWNERS);
                    break;
                }
                case 6: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_INV);
                    break;
                }
                case 7: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_DROPPED_ITEMS);
                    break;
                }
                case 8: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_ENTITIES_DROP);
                    break;
                }
                case -1: {
                    travelersCompassItem.writeCompassData(stack, CompassData.PAUSED);
                    break;
                }
                case -3: {
                    if (player.m_9236_().m_5776_()) break;
                    if (!travelersCompassItem.isPaused(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.PAUSED);
                    }
                    travelersCompassItem.writeCompassData(stack, CompassData.WIDE_SEARCH_SIGNAL);
                    break;
                }
                case -5: {
                    currentRadius = travelersCompassItem.blockSearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.blockSearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setBlockSearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -6: {
                    currentRadius = travelersCompassItem.entitySearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.entitySearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setEntitySearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -7: {
                    currentRadius = travelersCompassItem.containerSearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.containerSearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setContainerSearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -8: {
                    currentRadius = travelersCompassItem.wideSearchRadius(stack);
                    if (currentRadius + amount > (Integer)TCConfig.wideSearchRadius.get() || currentRadius + amount <= 0) break;
                    travelersCompassItem.setWideSearchRadius(stack, currentRadius + amount);
                    break;
                }
                case -9: {
                    travelersCompassItem.writeCompassData(stack, CompassData.PRIORITY_MODE);
                    break;
                }
                case -10: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SHOW_LABELS);
                    break;
                }
                case -11: {
                    if (travelersCompassItem.hudMode(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    if (travelersCompassItem.hudModeRequiresHeld(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                        break;
                    }
                    travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                    break;
                }
                case -12: {
                    travelersCompassItem.setContainerSearchRadius(stack, (int)((float)((Integer)TCConfig.containerSearchRadius.get()).intValue() * 0.5f));
                    travelersCompassItem.setEntitySearchRadius(stack, (int)((float)((Integer)TCConfig.entitySearchRadius.get()).intValue() * 0.5f));
                    travelersCompassItem.setBlockSearchRadius(stack, (int)((float)((Integer)TCConfig.blockSearchRadius.get()).intValue() * 0.5f));
                    travelersCompassItem.setWideSearchRadius(stack, (int)((float)((Integer)TCConfig.wideSearchRadius.get()).intValue() * 0.5f));
                    if (travelersCompassItem.showLabels(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.SHOW_LABELS);
                    }
                    if (!travelersCompassItem.priorityMode(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.PRIORITY_MODE);
                    }
                    if (!travelersCompassItem.sound(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.SOUND);
                    }
                    if (!travelersCompassItem.hudMode(stack)) ** GOTO lbl96
                    travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW);
                    ** GOTO lbl98
lbl96:
                    // 1 sources

                    if (travelersCompassItem.hudModeRequiresHeld(stack)) {
                        travelersCompassItem.writeCompassData(stack, CompassData.HUD_SHOW_HAND);
                    }
                }
lbl98:
                // 5 sources

                case -13: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SOUND);
                    break;
                }
                case -14: {
                    travelersCompassItem.writeCompassData(stack, CompassData.LAZY_MODE);
                    break;
                }
                case 401: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS_GOODS);
                    break;
                }
                case 402: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_VILLAGERS_COST);
                    break;
                }
                case 601: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_PLAYERS_INV);
                    break;
                }
                case 602: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MOBS_INV);
                    break;
                }
                case 603: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MINECARTS_INV);
                }
            }
        }
    }
}

