/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.network.packet;

import com.nine.travelerscompass.common.item.CompassData;
import com.nine.travelerscompass.common.item.TravelersCompassItem;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SearchButtonPacket {
    private final int ID;

    public SearchButtonPacket(int value) {
        this.ID = value;
    }

    public SearchButtonPacket(FriendlyByteBuf buf) {
        this.ID = buf.m_130242_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.ID);
    }

    public void onMessage(Supplier<NetworkEvent.Context> ctx) {
        ServerPlayer player = ctx.get().getSender();
        ItemStack stack = ((Player)Objects.requireNonNull(player)).m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof TravelersCompassItem) {
            TravelersCompassItem travelersCompassItem = (TravelersCompassItem)item;
            switch (this.ID) {
                case 1: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_MOBS);
                    break;
                }
                case 2: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_CONTAINERS);
                    break;
                }
                case 3: {
                    travelersCompassItem.writeCompassData(stack, CompassData.SEARCHING_BLOCKS);
                    break;
                }
                case 4: {
                    travelersCompassItem.setConfigMode(stack, true);
                    break;
                }
                case 5: {
                    travelersCompassItem.setConfigMode(stack, false);
                }
            }
        }
    }
}

