/*
 * Decompiled with CFR 0.152.
 */
package com.nine.travelerscompass.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LootUtils {
    public static List<LootPool> getPools(LootTable lootTable) {
        return lootTable.f_79109_;
    }

    public static List<LootPoolEntryContainer> getEntries(LootPool lootPool) {
        return List.of(lootPool.f_79023_);
    }

    public static List<LootItem> getLootItems(LootTable lootTable) {
        ArrayList<LootItem> dropList = new ArrayList<LootItem>();
        LootUtils.getPools(lootTable).forEach(lootPool -> LootUtils.getEntries(lootPool).stream().filter(entry -> entry instanceof LootItem).map(entry -> (LootItem)entry).forEach(dropList::add));
        dropList.removeIf(Objects::isNull);
        return dropList;
    }

    public static List<Item> getItemsFromLootTable(LootTable lootTable) {
        ArrayList<Item> dropStackList = new ArrayList<Item>();
        LootUtils.getLootItems(lootTable).stream().map(lootItem -> lootItem.f_79564_).forEach(dropStackList::add);
        return dropStackList;
    }

    public static List<ItemStack> getAllPossibleLootFromBlock(Block block, ServerLevel level, BlockPos pos) {
        ResourceLocation lootTableLocation = block.m_60589_();
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableLocation);
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81461_, (Object)level.m_8055_(pos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81455_, null).m_287289_(LootContextParams.f_81462_, (Object)level.m_7702_(pos));
        LootParams lootParams = paramsBuilder.m_287235_(LootContextParamSets.f_81421_);
        ArrayList<ItemStack> allPossibleLoot = new ArrayList<ItemStack>();
        lootTable.m_287228_(lootParams, item -> {
            if (!allPossibleLoot.contains(item)) {
                allPossibleLoot.add((ItemStack)item);
            }
        });
        return allPossibleLoot;
    }
}

