/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.reward;

import com.hrznstudio.titanium.reward.Reward;
import com.hrznstudio.titanium.reward.RewardGiver;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public class RewardManager {
    private static final RewardManager INSTANCE = new RewardManager();
    private final Map<UUID, RewardGiver> rewards = new ConcurrentHashMap<UUID, RewardGiver>();

    private RewardManager() {
    }

    public static RewardManager get() {
        return INSTANCE;
    }

    public RewardGiver getGiver(UUID uuid, String name) {
        return this.rewards.computeIfAbsent(uuid, uuid1 -> new RewardGiver(uuid, name));
    }

    public Map<UUID, RewardGiver> getRewards() {
        return this.rewards;
    }

    public List<ResourceLocation> collectRewardsResourceLocations(UUID uuid) {
        return this.rewards.values().stream().map(rewardGiver -> rewardGiver.collectRewardsResourceLocations(uuid)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Reward getReward(ResourceLocation resourceLocation) {
        for (RewardGiver value : this.rewards.values()) {
            for (Reward reward : value.getRewards()) {
                if (!reward.getResourceLocation().equals((Object)resourceLocation)) continue;
                return reward;
            }
        }
        return null;
    }
}

