/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.api.item;

import alexthw.ars_elemental.api.item.ISchoolProvider;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.util.CompatUtils;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotResult;

public interface ISchoolFocus
extends ISpellModifierItem,
ISchoolProvider {
    @Nullable
    public static SpellSchool hasFocus(Entity entity) {
        Player player;
        ISchoolFocus focus;
        if (entity instanceof ISchoolProvider) {
            ISchoolProvider mage = (ISchoolProvider)entity;
            return mage.getSchool();
        }
        if (entity instanceof Player && (focus = ISchoolFocus.getFocus(player = (Player)entity)) != null) {
            return focus.getSchool();
        }
        return null;
    }

    public static ISchoolFocus getFocus(@NotNull Player player) {
        Item item;
        for (InteractionHand curHand : InteractionHand.values()) {
            Item hand = player.m_21120_(curHand).m_41720_();
            if (!(hand instanceof ISchoolFocus)) continue;
            ISchoolFocus focus = (ISchoolFocus)hand;
            return focus;
        }
        SlotResult curio = CompatUtils.getCurio((LivingEntity)player, c -> c.m_41720_() instanceof ISchoolFocus);
        if (!curio.stack().m_41619_() && (item = curio.stack().m_41720_()) instanceof ISchoolFocus) {
            ISchoolFocus focus = (ISchoolFocus)item;
            return focus;
        }
        return null;
    }

    public double getDiscount();

    public static boolean fireCheck(SpellResolver resolver) {
        return resolver.hasFocus(((Item)ModItems.FIRE_FOCUS.get()).m_7968_()) || resolver.hasFocus(((Item)ModItems.LESSER_FIRE_FOCUS.get()).m_7968_());
    }

    public static boolean waterCheck(SpellResolver resolver) {
        return resolver.hasFocus(((Item)ModItems.WATER_FOCUS.get()).m_7968_()) || resolver.hasFocus(((Item)ModItems.LESSER_WATER_FOCUS.get()).m_7968_());
    }

    public static boolean earthCheck(SpellResolver resolver) {
        return resolver.hasFocus(((Item)ModItems.EARTH_FOCUS.get()).m_7968_()) || resolver.hasFocus(((Item)ModItems.LESSER_EARTH_FOCUS.get()).m_7968_());
    }

    public static boolean airCheck(SpellResolver resolver) {
        return resolver.hasFocus(((Item)ModItems.AIR_FOCUS.get()).m_7968_()) || resolver.hasFocus(((Item)ModItems.LESSER_AIR_FOCUS.get()).m_7968_());
    }
}

