/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.ISchoolProvider;
import alexthw.ars_elemental.common.entity.ai.FireCannonGoal;
import alexthw.ars_elemental.common.glyphs.MethodHomingProjectile;
import alexthw.ars_elemental.registry.ModEntities;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.client.ITooltipProvider;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.entity.IDispellable;
import com.hollingsworth.arsnouveau.api.item.IWandable;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.NBTUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.block.tile.IAnimationListener;
import com.hollingsworth.arsnouveau.common.entity.EntityHomingProjectileSpell;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectFlare;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectIgnite;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectKnockback;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FirenandoEntity
extends PathfinderMob
implements ISchoolProvider,
RangedAttackMob,
GeoEntity,
ITooltipProvider,
IAnimationListener,
IWandable,
IDispellable,
IVariantColorProvider<FirenandoEntity> {
    private final RawAnimation idle = RawAnimation.begin().thenLoop("idle.body");
    private final RawAnimation inactive = RawAnimation.begin().thenPlayAndHold("inactive");
    private final RawAnimation mainIdle = RawAnimation.begin().thenLoop("idle");
    private int castCooldown = 0;
    private final ParticleColor color = new ParticleColor(250, 50, 15);
    private final ParticleColor colorAlt = new ParticleColor(15, 100, 200);
    public final Spell spell = new Spell(new AbstractSpellPart[]{MethodHomingProjectile.INSTANCE, EffectIgnite.INSTANCE, AugmentSensitive.INSTANCE, EffectFlare.INSTANCE, AugmentAmplify.INSTANCE, EffectKnockback.INSTANCE});
    public UUID owner;
    public static final EntityDataAccessor<Optional<BlockPos>> HOME = SynchedEntityData.m_135353_(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    public static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHOOTING = SynchedEntityData.m_135353_(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> COLOR = SynchedEntityData.m_135353_(FirenandoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    AnimationController<FirenandoEntity> attackController;

    public FirenandoEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public FirenandoEntity(Level world) {
        super((EntityType)ModEntities.FIRENANDO_ENTITY.get(), world);
    }

    public boolean m_7307_(@NotNull Entity pEntity) {
        return !(pEntity instanceof Enemy) || super.m_7307_(pEntity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.castCooldown > 0) {
            --this.castCooldown;
        }
        if (!this.m_9236_().m_5776_() && this.m_9236_().m_46467_() % 20L == 0L && this.isActive() && this.m_21223_() < this.m_21233_()) {
            this.m_5634_(1.0f);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268469_) || source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_21525_() {
        return super.m_21525_() || !this.isActive();
    }

    public void m_6667_(@NotNull DamageSource source) {
        if (!this.m_9236_().f_46443_ && !source.m_269533_(DamageTypeTags.f_268738_)) {
            this.f_19804_.m_135381_(ACTIVE, (Object)false);
            if (source.m_7639_() != null) {
                if (((Boolean)ConfigHandler.Common.FIRENANDO_KILL.get()).booleanValue() && source.m_7639_().m_20148_().equals(this.getOwner())) {
                    this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItems.FIRENANDO_CHARM.get())));
                    super.m_6667_(source);
                    return;
                }
                Entity entity = source.m_7639_();
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_6710_(null);
                }
            }
            this.m_21153_(0.1f);
            return;
        }
        super.m_6667_(source);
    }

    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.m_213877_() || this.m_9236_().f_46443_) {
            return false;
        }
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItems.FIRENANDO_CHARM.get())));
        ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)this.m_20183_());
        this.m_142687_(Entity.RemovalReason.DISCARDED);
        return true;
    }

    public void m_6504_(@NotNull LivingEntity target, float pVelocity) {
        ParticleColor spellColor = this.getColor(this).equals(Variants.MAGMA.toString()) ? this.color : this.colorAlt;
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(this.m_9236_(), this.spell, (LivingEntity)this, (IWrappedCaster)new LivingCaster((LivingEntity)this)).withColors(spellColor));
        EntityHomingProjectileSpell projectileSpell = new EntityHomingProjectileSpell(this.m_9236_(), (SpellResolver)resolver);
        List<Predicate<LivingEntity>> ignore = MethodHomingProjectile.basicIgnores((LivingEntity)this, false, resolver.spell);
        ignore.add(entity -> !(entity instanceof Enemy));
        ignore.add(entity -> {
            if (!(entity instanceof FirenandoEntity)) return false;
            FirenandoEntity firenando = (FirenandoEntity)entity;
            if (!this.getOwner().equals(firenando.getOwner())) return false;
            return true;
        });
        projectileSpell.setColor(spellColor);
        projectileSpell.shoot((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.8f, 0.8f);
        projectileSpell.setIgnored(ignore);
        this.m_9236_().m_7967_((Entity)projectileSpell);
        this.castCooldown = 20;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new GoBackHomeGoal((Mob)this, this::getHome, 12, () -> this.m_5448_() == null));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, false, entity -> entity instanceof Enemy));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FireCannonGoal(this, 0.8, 20, 55.0f, () -> this.castCooldown <= 0 && this.isActive(), Animations.SHOOT.ordinal(), 20));
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public int m_213860_() {
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 16.0);
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable LivingEntity storedEntity, Player playerEntity) {
        if (storedPos != null) {
            this.setHome(storedPos);
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.m_237115_((String)"ars_nouveau.home_set"));
        }
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public void setHome(BlockPos home) {
        this.f_19804_.m_135381_(HOME, Optional.of(home));
    }

    @Nullable
    public BlockPos getHome() {
        return ((Optional)this.f_19804_.m_135370_(HOME)).orElse(null);
    }

    public UUID getOwner() {
        return this.owner;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOTING, (Object)false);
        this.f_19804_.m_135372_(ACTIVE, (Object)true);
        this.f_19804_.m_135372_(HOME, Optional.empty());
        this.f_19804_.m_135372_(COLOR, (Object)Variants.MAGMA.toString());
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        NBTUtil.storeBlockPos((CompoundTag)tag, (String)"home", (BlockPos)this.getHome());
        tag.m_128405_("cast", this.castCooldown);
        tag.m_128379_("active", ((Boolean)this.f_19804_.m_135370_(ACTIVE)).booleanValue());
        tag.m_128359_("color", (String)this.f_19804_.m_135370_(COLOR));
        if (this.owner != null) {
            tag.m_128362_("owner", this.owner);
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (NBTUtil.hasBlockPos((CompoundTag)tag, (String)"home")) {
            this.setHome(NBTUtil.getNullablePos((CompoundTag)tag, (String)"home"));
        }
        this.castCooldown = tag.m_128451_("cast");
        this.f_19804_.m_135381_(ACTIVE, (Object)tag.m_128471_("active"));
        this.f_19804_.m_135381_(COLOR, (Object)tag.m_128461_("color"));
        this.owner = tag.m_128403_("owner") ? tag.m_128342_("owner") : null;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 5, event -> this.isActive() ? event.setAndContinue(this.idle) : event.setAndContinue(this.inactive))});
        this.attackController = new AnimationController((GeoAnimatable)this, "attack_controller", 1, this::attackPredicate);
        data.add(new AnimationController[]{this.attackController});
    }

    PlayState attackPredicate(AnimationState<FirenandoEntity> event) {
        if (!this.isActive()) {
            return PlayState.STOP;
        }
        if (this.attackController.getCurrentAnimation() == null) {
            return event.setAndContinue(this.mainIdle);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void startAnimation(int arg) {
        if (arg == Animations.SHOOT.ordinal()) {
            if (this.attackController.getCurrentAnimation() != null && this.attackController.getCurrentAnimation().animation().name().equals("shoot")) {
                return;
            }
            this.attackController.forceAnimationReset();
            this.attackController.setAnimation(RawAnimation.begin().thenPlay("shoot").thenLoop("idle"));
        }
    }

    public void setOwner(Player player) {
        this.owner = player.m_20148_();
    }

    public void getTooltip(List<Component> tooltip) {
        if (this.getHome() != null) {
            String home = this.getHome().m_123341_() + ", " + this.getHome().m_123342_() + ", " + this.getHome().m_123343_();
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{home}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"ars_nouveau.weald_walker.home", (Object[])new Object[]{Component.m_237115_((String)"ars_nouveau.nothing").getString()}));
        }
    }

    @Override
    public SpellSchool getSchool() {
        return SpellSchools.ELEMENTAL_FIRE;
    }

    public String getColor(FirenandoEntity firenando) {
        return (String)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(String color, FirenandoEntity firenando) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    @NotNull
    protected InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack;
        if (!player.m_9236_().f_46443_ && player.m_20148_().equals(this.owner)) {
            stack = player.m_21120_(hand);
            if (stack.m_41720_() == Blocks.f_50450_.m_5456_() && !this.getColor(this).equals(Variants.MAGMA.toString())) {
                this.setColor(Variants.MAGMA.toString(), this);
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            if (stack.m_41720_() == Blocks.f_50135_.m_5456_() && !this.getColor(this).equals(Variants.SOUL.toString())) {
                this.setColor(Variants.SOUL.toString(), this);
                stack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
        }
        if (!(player.m_9236_().m_5776_() || this.isActive() || (stack = player.m_21120_(hand)).m_41720_() != Items.f_42542_ && stack.m_41720_() != Items.f_42593_)) {
            this.m_5634_(100.0f);
            this.f_19804_.m_135381_(ACTIVE, (Object)true);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public ResourceLocation getTexture(FirenandoEntity entity) {
        if (!this.isActive()) {
            return ArsElemental.prefix("textures/entity/firenando_inactive.png");
        }
        return ArsElemental.prefix("textures/entity/firenando_" + (this.getColor(entity).isEmpty() ? Variants.MAGMA.toString() : this.getColor(entity)) + ".png");
    }

    public static enum Variants {
        MAGMA,
        SOUL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Animations {
        SHOOT;

    }
}

