/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.util.EntityCarryMEI;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class FollowOwnerGoal
extends Goal {
    private final Mob mob;
    @Nullable
    public LivingEntity followingMob;
    private final double speedModifier;
    private PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public FollowOwnerGoal(Mob pMob, double pSpeedModifier, float pStopDistance, float pAreaSize) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.navigation = pMob.m_21573_();
        this.stopDistance = pStopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(pMob.m_21573_() instanceof GroundPathNavigation) && !(pMob.m_21573_() instanceof FlyingPathNavigation)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    public boolean m_8036_() {
        EntityCarryMEI charm;
        LivingEntity ownerEntity;
        if (!this.mob.m_21023_((MobEffect)ModPotions.ENTHRALLED.get()) || this.mob.m_5448_() != null) {
            return false;
        }
        MobEffectInstance charmInstance = this.mob.m_21124_((MobEffect)ModPotions.ENTHRALLED.get());
        if (charmInstance instanceof EntityCarryMEI && (ownerEntity = (charm = (EntityCarryMEI)charmInstance).getOwner()) instanceof LivingEntity) {
            LivingEntity living;
            this.followingMob = living = ownerEntity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.followingMob != null && !this.navigation.m_26571_() && this.mob.m_20280_((Entity)this.followingMob) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.navigation = this.mob.m_21573_();
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.followingMob = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.followingMob != null && !this.mob.m_21523_()) {
            this.mob.m_21563_().m_24960_((Entity)this.followingMob, 10.0f, (float)this.mob.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                double d2;
                double d1;
                this.navigation = this.mob.m_21573_();
                this.timeToRecalcPath = this.m_183277_(10);
                double d0 = this.mob.m_20185_() - this.followingMob.m_20185_();
                double d3 = d0 * d0 + (d1 = this.mob.m_20186_() - this.followingMob.m_20186_()) * d1 + (d2 = this.mob.m_20189_() - this.followingMob.m_20189_()) * d2;
                if (!(d3 <= (double)(this.stopDistance * this.stopDistance))) {
                    this.navigation.m_5624_((Entity)this.followingMob, this.speedModifier);
                } else {
                    this.navigation.m_26573_();
                    if (d3 <= (double)this.stopDistance) {
                        double d4 = this.followingMob.m_20185_() - this.mob.m_20185_();
                        double d5 = this.followingMob.m_20189_() - this.mob.m_20189_();
                        this.navigation.m_26519_(this.mob.m_20185_() - d4, this.mob.m_20186_(), this.mob.m_20189_() - d5, this.speedModifier);
                    }
                }
            }
        }
    }
}

