/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.familiars;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.common.entity.MermaidEntity;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.client.IVariantColorProvider;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.compat.PatchouliHandler;
import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.FlyingFamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.familiar.ISpellCastListener;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class MermaidFamiliar
extends FlyingFamiliarEntity
implements ISpellCastListener,
IVariantColorProvider<FamiliarEntity> {
    RawAnimation swim = RawAnimation.begin().thenLoop("swim");
    RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    RawAnimation ground = RawAnimation.begin().thenLoop("ground");
    RawAnimation floating = RawAnimation.begin().thenLoop("floating");

    public MermaidFamiliar(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
    }

    public MermaidFamiliar(Level level) {
        this((EntityType<? extends PathfinderMob>)((EntityType)ModEntities.SIREN_FAMILIAR.get()), level);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    @NotNull
    public InteractionResult m_7111_(@NotNull Player pPlayer, @NotNull Vec3 pVec, @NotNull InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND || pPlayer.m_20193_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = pPlayer.m_21120_(hand);
        String color = MermaidEntity.Variants.getColorFromStack(stack);
        if (color != null && !this.getColor().equals(color)) {
            this.setColor(color);
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(pPlayer, pVec, hand);
    }

    public void onModifier(SpellModifierEvent event) {
        if (this.m_6084_() && this.getOwner() != null && this.getOwner().equals((Object)event.caster) && SpellSchools.ELEMENTAL_WATER.isPartOfSchool(event.spellPart)) {
            event.builder.addDamageModifier(2.0);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_20069_() && this.m_9236_().m_46467_() % 60L == 0L && this.getOwner() != null) {
            this.getOwner().m_7292_(new MobEffectInstance(MobEffects.f_19593_, 600, 1, false, false, true));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19593_, 600, 1, false, false, true));
        }
        if (!this.m_9236_().f_46443_ && this.m_9236_().m_46467_() % 10L == 0L && this.m_7755_().getString().toLowerCase(Locale.ROOT).equals("jeb_")) {
            this.f_19804_.m_135381_(COLOR, (Object)MermaidEntity.Variants.random().toString());
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        super.registerControllers(data);
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "actionController", 10, event -> event.setAndContinue(this.m_20184_().m_82553_() > 0.0 || this.m_9236_().f_46443_ && PatchouliHandler.isPatchouliWorld() ? this.swim : this.idle))});
    }

    public PlayState walkPredicate(AnimationState event) {
        return event.setAndContinue(this.m_20096_() && !this.m_20069_() || this.m_9236_().f_46443_ && PatchouliHandler.isPatchouliWorld() ? this.ground : this.floating);
    }

    @NotNull
    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.SIREN_FAMILIAR.get();
    }

    protected PathNavigation m_6037_(Level world) {
        PathNavigation newNav = super.m_6037_(world);
        newNav.m_7008_(false);
        return newNav;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135381_(COLOR, (Object)MermaidEntity.Variants.KELP.toString());
    }

    public void setColor(String color, FamiliarEntity object) {
        super.setColor(color);
    }

    public String getColor(FamiliarEntity mermaidFamiliar) {
        return (String)this.f_19804_.m_135370_(COLOR);
    }

    public ResourceLocation getTexture(FamiliarEntity entity) {
        return ArsElemental.prefix("textures/entity/mermaid_" + (this.getColor().isEmpty() ? MermaidEntity.Variants.KELP.toString() : this.getColor()) + ".png");
    }
}

