/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ConfigHandler;
import alexthw.ars_elemental.api.item.IElementalArmor;
import alexthw.ars_elemental.api.item.ISchoolBangle;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.blocks.ElementalSpellTurretTile;
import alexthw.ars_elemental.common.entity.FirenandoEntity;
import alexthw.ars_elemental.common.glyphs.EffectBubbleShield;
import alexthw.ars_elemental.common.mob_effects.EnthrallEffect;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.recipe.HeadCutRecipe;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCut;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.RegistryHelper;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ars_elemental")
public class DamageEvents {
    @SubscribeEvent
    public static void betterFilters(SpellDamageEvent.Pre event) {
        IFilter filter;
        Object e;
        if (event.context != null && event.context.getCurrentIndex() > 0 && (e = event.context.getSpell().recipe.get(event.context.getCurrentIndex() - 1)) instanceof IFilter && !(filter = (IFilter)e).shouldResolveOnEntity(event.target, event.target.f_19853_)) {
            event.setCanceled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void bypassRes(LivingAttackEvent event) {
        Entity focus;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (living != null) {
                focus = ISchoolFocus.hasFocus((Entity)player);
                if (focus == null) return;
                switch (focus.getId()) {
                    case "fire": {
                        if (!event.getSource().m_269533_(DamageTypeTags.f_268745_)) return;
                        if (!living.m_5825_()) {
                            if (!living.m_21023_(MobEffects.f_19607_)) return;
                        }
                        event.setCanceled(true);
                        DamageSource newDamage = DamageUtil.source((LevelAccessor)player.f_19853_, ModRegistry.MAGIC_FIRE, (Entity)player);
                        living.m_6469_(newDamage, event.getAmount());
                        return;
                    }
                    case "water": {
                        if (!event.getSource().m_269533_(DamageTypeTags.f_268581_)) return;
                        if (living.m_6336_() != MobType.f_21644_) return;
                        event.setCanceled(true);
                        DamageSource newDamage = DamageUtil.source((LevelAccessor)player.f_19853_, (ResourceKey)DamageTypes.f_268515_, (Entity)player);
                        living.m_6469_(newDamage, event.getAmount());
                        return;
                    }
                }
                return;
            }
        }
        if (!((focus = event.getSource().m_7639_()) instanceof FirenandoEntity)) return;
        FirenandoEntity FE = (FirenandoEntity)focus;
        if (!(living instanceof Monster)) {
            event.setCanceled(true);
            living.m_20095_();
            return;
        }
        Monster mob = (Monster)living;
        if (!mob.m_5825_()) {
            if (!living.m_21023_(MobEffects.f_19607_)) return;
        }
        if (!event.getSource().m_269533_(DamageTypeTags.f_268745_)) return;
        event.setCanceled(true);
        mob.m_6469_(DamageUtil.source((LevelAccessor)FE.f_19853_, ModRegistry.MAGIC_FIRE, (Entity)FE), event.getAmount());
    }

    @SubscribeEvent
    public static void banglesSpecials(LivingAttackEvent event) {
        Player player;
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof Player) {
            SpellSchool bangle;
            player = (Player)entity;
            if (living != null && living != player && (bangle = ISchoolBangle.hasBangle(event.getEntity().m_9236_(), (Entity)player)) != null) {
                switch (bangle.getId()) {
                    case "fire": {
                        living.m_20254_(5);
                        break;
                    }
                    case "water": {
                        living.m_146917_(living.m_146888_() + 100);
                        break;
                    }
                    case "earth": {
                        living.m_7292_(new MobEffectInstance((MobEffect)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SNARE_EFFECT.get(), 60));
                        break;
                    }
                    case "necromancy": {
                        if (player.m_217043_().m_188499_()) {
                            living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60));
                            break;
                        }
                        living.m_5634_(1.0f);
                        player.m_5634_(1.0f);
                        break;
                    }
                    case "conjuration": {
                        BlockPos pos = player.m_20183_();
                        player.m_9236_().m_6443_(LivingEntity.class, new AABB(pos.m_122013_(30).m_122025_(30).m_6625_(10).m_252807_(), pos.m_122020_(30).m_122030_(30).m_6630_(10).m_252807_()), e -> {
                            ISummon s;
                            return e instanceof ISummon && player.equals((Object)(s = (ISummon)e).getOwnerAlt());
                        }).forEach(e -> {
                            if (e instanceof Monster) {
                                Monster mob = (Monster)e;
                                mob.m_6710_(living);
                            } else if (e instanceof NeutralMob) {
                                NeutralMob neutralMob = (NeutralMob)e;
                                neutralMob.m_6710_(living);
                            }
                            e.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 80, 1));
                        });
                    }
                }
            }
        }
        if (living instanceof Player) {
            player = (Player)living;
            if ((event.getSource().m_276093_(DamageTypes.f_268585_) || event.getSource().m_276093_(DamageTypes.f_268469_)) && ISchoolBangle.hasBangle(event.getEntity().m_9236_(), (Entity)player) == SpellSchools.ELEMENTAL_EARTH) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleHealing(LivingHealEvent event) {
        Player player;
        LivingEntity livingEntity;
        if (((Boolean)ConfigHandler.COMMON.EnableGlyphEmpowering.get()).booleanValue() || (livingEntity = event.getEntity()) instanceof Player && ISchoolFocus.hasFocus((Entity)(player = (Player)livingEntity)) == SpellSchools.ELEMENTAL_EARTH) {
            event.setAmount(event.getAmount() * 1.5f);
        }
        if (event.getEntity().m_21023_((MobEffect)ModPotions.FROZEN.get())) {
            event.setCanceled(true);
        }
        if (event.getEntity().m_21023_((MobEffect)ModPotions.MAGIC_FIRE.get()) && ((Boolean)ConfigHandler.COMMON.IFRAME_SKIP.get()).booleanValue()) {
            event.setAmount((float)((double)event.getAmount() * 1.25));
            event.getEntity().f_19802_ = 0;
        }
    }

    @SubscribeEvent
    public static void damageTweaking(LivingHurtEvent event) {
        boolean not_bypassEnchants;
        Entity dealer = event.getSource().m_7639_();
        LivingEntity target = event.getEntity();
        SpellSchool focus = ISchoolFocus.hasFocus(dealer);
        if (dealer instanceof Player && focus != null) {
            switch (focus.getId()) {
                case "water": {
                    if (!(target.m_146889_() > 0.75f) || !event.getSource().m_269533_(DamageTypeTags.f_268419_)) break;
                    event.setAmount(event.getAmount() * 1.25f);
                    break;
                }
                case "air": {
                    if (!target.m_21023_(MobEffects.f_19620_) || !event.getSource().m_269533_(DamageTypeTags.f_268549_)) break;
                    event.setAmount(event.getAmount() * 1.25f);
                }
            }
        }
        HashMap<SpellSchool, Integer> bonusMap = new HashMap<SpellSchool, Integer>();
        int bonusReduction = 0;
        for (ItemStack stack : event.getEntity().m_6168_()) {
            IElementalArmor armor;
            Item item = stack.m_41720_();
            if (!(item instanceof IElementalArmor) || !(armor = (IElementalArmor)item).doAbsorb(event.getSource())) continue;
            ++bonusReduction;
            if (bonusMap.containsKey(armor.getSchool())) {
                bonusMap.put(armor.getSchool(), (Integer)bonusMap.get(armor.getSchool()) + 1);
                continue;
            }
            bonusMap.put(armor.getSchool(), 1);
        }
        boolean bl = not_bypassEnchants = !event.getSource().m_269533_(DamageTypeTags.f_268413_);
        if (target instanceof Player) {
            LivingEntity living;
            Player player = (Player)target;
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof LivingEntity && EnthrallEffect.isEnthralledBy(living = (LivingEntity)entity, player)) {
                event.setAmount(event.getAmount() * 0.5f);
            }
            if (not_bypassEnchants) {
                if (event.getSource().m_276093_(DamageTypes.f_268576_) && ISchoolFocus.hasFocus((Entity)player) == SpellSchools.ELEMENTAL_AIR) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_FIRE, 0) == 4 && event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                    player.m_20095_();
                    if (ISchoolFocus.hasFocus((Entity)player) == SpellSchools.ELEMENTAL_FIRE) {
                        player.m_7292_(new MobEffectInstance((MobEffect)com.hollingsworth.arsnouveau.setup.registry.ModPotions.SPELL_DAMAGE_EFFECT.get(), 200, 2));
                    }
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_WATER, 0) == 4 && event.getSource().m_276093_(DamageTypes.f_268722_)) {
                    player.m_20301_(player.m_6062_());
                    bonusReduction += 5;
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_EARTH, 0) == 4 && player.m_146892_().m_7098_() < 20.0 && player.m_36324_().m_38702_() < 2) {
                    player.m_36324_().m_38705_(20);
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_AIR, 0) == 4 && event.getSource().m_269533_(DamageTypeTags.f_268549_)) {
                    bonusReduction += 5;
                }
                if (bonusReduction > 0) {
                    int finalBonusReduction = bonusReduction;
                    CapabilityRegistry.getMana((LivingEntity)player).ifPresent(mana -> {
                        if (finalBonusReduction > 3) {
                            mana.addMana((double)(event.getAmount() * 5.0f));
                        }
                        event.getEntity().m_7292_(new MobEffectInstance((MobEffect)com.hollingsworth.arsnouveau.setup.registry.ModPotions.MANA_REGEN_EFFECT.get(), 200, finalBonusReduction / 2));
                    });
                }
            }
        }
        if (bonusReduction > 0 && not_bypassEnchants) {
            event.setAmount(event.getAmount() * (1.0f - (float)bonusReduction / 10.0f));
        }
        int ManaBubbleCost = (Integer)EffectBubbleShield.INSTANCE.GENERIC_INT.get();
        if (not_bypassEnchants && event.getEntity() != null && event.getEntity().m_21023_((MobEffect)ModPotions.MANA_BUBBLE.get())) {
            LivingEntity living = event.getEntity();
            CapabilityRegistry.getMana((LivingEntity)event.getEntity()).ifPresent(mana -> {
                double maxReduction = mana.getCurrentMana() / (double)ManaBubbleCost;
                double amp = Math.min(1.0 + (double)living.m_21124_((MobEffect)ModPotions.MANA_BUBBLE.get()).m_19564_() / 2.0, maxReduction);
                float newDamage = (float)Math.max(0.1, (double)event.getAmount() - amp);
                float actualReduction = event.getAmount() - newDamage;
                if (actualReduction > 0.0f && mana.getCurrentMana() >= (double)ManaBubbleCost) {
                    event.setAmount(newDamage);
                    mana.removeMana((double)(actualReduction * (float)ManaBubbleCost));
                }
                if (mana.getCurrentMana() < (double)ManaBubbleCost) {
                    living.m_21195_((MobEffect)ModPotions.MANA_BUBBLE.get());
                }
            });
        }
    }

    @SubscribeEvent
    public static void statusProtect(MobEffectEvent.Applicable event) {
        if (event.getEntity().m_21023_((MobEffect)ModPotions.MANA_BUBBLE.get())) {
            if (event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL) {
                Optional effects = event.getEntity().f_19853_.m_9598_().m_175515_(Registries.f_256929_).m_203431_(AETagsProvider.AEMobEffectTagProvider.BUBBLE_BLACKLIST);
                if (effects.isPresent() && ((HolderSet.Named)effects.get()).m_203614_().anyMatch(effect -> effect.get() == event.getEffectInstance().m_19544_())) {
                    return;
                }
                int ManaBubbleCost = (Integer)EffectBubbleShield.INSTANCE.GENERIC_INT.get() * 2;
                if (event.getEntity().m_217043_().m_188503_(10) == 0) {
                    CapabilityRegistry.getMana((LivingEntity)event.getEntity()).ifPresent(mana -> {
                        if (mana.getCurrentMana() >= (double)ManaBubbleCost) {
                            mana.removeMana((double)ManaBubbleCost / 2.0);
                            event.setResult(Event.Result.DENY);
                        }
                    });
                }
            } else if (event.getEffectInstance().m_19544_() == ModPotions.MAGIC_FIRE.get()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void vorpalCut(SpellDamageEvent.Post event) {
        SpellSchool spellSchool;
        TileCaster tc;
        LivingEntity living;
        Entity entity = event.target;
        if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).m_21223_() > 0.0f) {
            return;
        }
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (iWrappedCaster instanceof TileCaster && (iWrappedCaster = (tc = (TileCaster)iWrappedCaster).getTile()) instanceof ElementalSpellTurretTile) {
            ElementalSpellTurretTile turret = (ElementalSpellTurretTile)iWrappedCaster;
            spellSchool = turret.getSchool();
        } else {
            spellSchool = ISchoolFocus.hasFocus((Entity)event.caster);
        }
        SpellSchool school = spellSchool;
        Spell subspell = new Spell(event.context.getSpell().recipe.subList(event.context.getCurrentIndex() - 1, event.context.getSpell().recipe.size()));
        if (subspell.recipe.get(0) == EffectCut.INSTANCE && school == SpellSchools.ELEMENTAL_AIR) {
            ItemStack skull = null;
            int chance = 0;
            ResourceLocation mob = RegistryHelper.getRegistryName((EntityType)living.m_6095_());
            if (living instanceof Player) {
                Player player = (Player)living;
                GameProfile gameprofile = player.m_36316_();
                skull = new ItemStack((ItemLike)Items.f_42680_);
                chance = 20;
                skull.m_41784_().m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gameprofile));
            } else {
                for (HeadCutRecipe recipe : living.m_9236_().m_7465_().m_44013_((RecipeType)ModRegistry.HEAD_CUT.get())) {
                    if (!recipe.mob.equals((Object)mob)) continue;
                    skull = recipe.result.m_41777_();
                    chance = recipe.chance;
                    break;
                }
            }
            if (skull == null) {
                return;
            }
            int looting = Math.min(3, subspell.getBuffsAtIndex(0, event.caster, (AbstractAugment)AugmentFortune.INSTANCE));
            for (int i = -1; i < looting; ++i) {
                if (living.m_217043_().m_188503_(100) > chance) continue;
                living.m_19983_(skull);
                break;
            }
        }
    }
}

