/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.network;

import alexthw.ars_elemental.network.NetworkManager;
import alexthw.ars_elemental.registry.ModParticles;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.client.particle.ColoredDynamicTypeData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class DischargeEffectPacket {
    public Vec3 from;
    public Vec3 to;
    public ParticleColor color;

    public DischargeEffectPacket(Vec3 from, Vec3 to, ParticleColor colors) {
        this.from = from;
        this.to = to;
        this.color = colors;
    }

    public static void encode(DischargeEffectPacket msg, FriendlyByteBuf buf) {
        DischargeEffectPacket.encodePos(buf, msg.from);
        DischargeEffectPacket.encodePos(buf, msg.to);
        buf.writeInt(msg.color.getColor());
    }

    public static void encodePos(@Nonnull FriendlyByteBuf buf, @Nonnull Vec3 item) {
        buf.writeDouble(item.f_82479_);
        buf.writeDouble(item.f_82480_);
        buf.writeDouble(item.f_82481_);
    }

    public static DischargeEffectPacket decode(FriendlyByteBuf buf) {
        Vec3 from = DischargeEffectPacket.decodeVector3d(buf);
        Vec3 to = DischargeEffectPacket.decodeVector3d(buf);
        int colors = buf.readInt();
        return new DischargeEffectPacket(from, to, ParticleColor.fromInt((int)colors));
    }

    public static Vec3 decodeVector3d(@Nonnull FriendlyByteBuf buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        return new Vec3(x, y, z);
    }

    public static void send(@Nonnull Level level, @Nonnull ParticleColor spellColor, @Nonnull Vec3 fromPoint, @Nonnull Vec3 hitPoint) {
        Vec3 midpoint = fromPoint.m_82549_(hitPoint).m_82490_(0.5);
        double radius = 64.0 + fromPoint.m_82554_(midpoint);
        double radiusSqr = radius * radius;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            DischargeEffectPacket fx = new DischargeEffectPacket(fromPoint, hitPoint, spellColor);
            serverLevel.m_8795_(p -> p.m_20238_(midpoint) <= radiusSqr).forEach(p -> NetworkManager.INSTANCE.send(PacketDistributor.PLAYER.with(() -> p), (Object)fx));
        }
    }

    public static void whenThisPacketIsReceived(DischargeEffectPacket msg, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                Level level = ArsNouveau.proxy.getClientWorld();
                Player player = ArsNouveau.proxy.getPlayer();
                double distance = msg.from.m_82554_(msg.to);
                double start = 0.0;
                double increment = 0.25;
                if (player.m_20182_().m_82557_(msg.from) < 4.0 && msg.to.m_82546_(msg.from).m_82541_().m_82526_(player.m_20252_(1.0f)) > (double)(Mth.f_13994_ / 2.0f)) {
                    start = Math.min(2.0, distance / 2.0);
                    increment = 0.125;
                }
                for (double d = start; d < distance; d += increment) {
                    double fractionalDistance = d / distance;
                    double speedCoefficient = Mth.m_14139_((double)fractionalDistance, (double)0.2, (double)0.001);
                    if (ModList.get().isLoaded("cofh_core")) {
                        level.m_7106_((ParticleOptions)new ColoredDynamicTypeData((ParticleType)com.hollingsworth.arsnouveau.client.registry.ModParticles.SPARKLE_TYPE.get(), msg.color, 0.5f, 10), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82479_, (double)msg.to.f_82479_), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82480_, (double)msg.to.f_82480_) + 0.5, Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82481_, (double)msg.to.f_82481_), ((double)level.f_46441_.m_188501_() - 0.25) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.25) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.25) * speedCoefficient);
                        level.m_7106_((ParticleOptions)ModParticles.SPARK.get(), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82479_, (double)msg.to.f_82479_), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82480_, (double)msg.to.f_82480_) + 0.5, Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82481_, (double)msg.to.f_82481_), ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient);
                        continue;
                    }
                    level.m_7106_((ParticleOptions)new ColoredDynamicTypeData((ParticleType)com.hollingsworth.arsnouveau.client.registry.ModParticles.SPARKLE_TYPE.get(), msg.color, 0.5f, 10), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82479_, (double)msg.to.f_82479_), Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82480_, (double)msg.to.f_82480_) + 0.5, Mth.m_14139_((double)fractionalDistance, (double)msg.from.f_82481_, (double)msg.to.f_82481_), ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient, ((double)level.f_46441_.m_188501_() - 0.5) * speedCoefficient);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

