/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.client.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.mc.TooltipUtils;
import team.creative.solonion.client.gui.Page;
import team.creative.solonion.client.gui.elements.UILabel;
import team.creative.solonion.client.gui.screen.FoodBookScreen;
import team.creative.solonion.common.benefit.BenefitThreshold;

public class BenefitsPage
extends Page {
    private static final int BENEFITS_PER_PAGE = 3;
    private final Color activeColor;

    private BenefitsPage(Rectangle frame, String header, List<BenefitThreshold> benefitInfo, Color activeColor) {
        super(frame, header);
        this.activeColor = activeColor;
        for (BenefitThreshold info : benefitInfo) {
            this.addBenefitInfo(info);
        }
    }

    public static List<BenefitsPage> pages(Rectangle frame, String header, List<BenefitThreshold> benefitInfo, Color activeColor) {
        ArrayList<BenefitsPage> pages = new ArrayList<BenefitsPage>();
        for (int startIndex = 0; startIndex < benefitInfo.size(); startIndex += 3) {
            int endIndex = Math.min(startIndex + 3, benefitInfo.size());
            pages.add(new BenefitsPage(frame, header, benefitInfo.subList(startIndex, endIndex), activeColor));
        }
        return pages;
    }

    private void addBenefitInfo(BenefitThreshold info) {
        String thresh = "" + info.threshold;
        Object name = "";
        double value = info.benefit.value;
        Object object = info.benefit.property.value;
        if (object instanceof MobEffect) {
            MobEffect m = (MobEffect)object;
            name = LanguageUtils.translate((String)m.m_19481_());
            int amplifier = (int)value;
            name = (String)name + " " + TooltipUtils.printRoman((int)(amplifier + 1));
        } else {
            Object amplifier = info.benefit.property.value;
            if (amplifier instanceof Attribute) {
                Attribute a = (Attribute)amplifier;
                name = LanguageUtils.translate((String)a.m_22087_());
                String op = "+";
                if (value < 0.0) {
                    op = "-";
                }
                String modifierValue = op + Math.abs(value);
                name = (String)name + " " + modifierValue;
            }
        }
        UILabel thresholdLabel = new UILabel(LanguageUtils.translate((String)"gui.solonion.food_book.benefits.threshold_label") + ": " + thresh);
        thresholdLabel.color = this.activeColor;
        if (this.activeColor.equals(FoodBookScreen.activeGreen)) {
            thresholdLabel.tooltip = LanguageUtils.translate((String)"gui.solonion.food_book.benefits.active_tooltip");
        } else if (this.activeColor.equals(FoodBookScreen.inactiveRed)) {
            thresholdLabel.tooltip = LanguageUtils.translate((String)"gui.solonion.food_book.benefits.inactive_tooltip");
        }
        UILabel nameLabel = new UILabel((String)name);
        nameLabel.color = FoodBookScreen.lessBlack;
        this.mainStack.addChild(thresholdLabel);
        this.mainStack.addChild(nameLabel);
        this.mainStack.addChild(this.makeSeparatorLine());
        this.updateMainStack();
    }
}

