/*
 * Decompiled with CFR 0.152.
 */
package team.creative.solonion.common.event;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.solonion.api.BenefitCapability;
import team.creative.solonion.api.FoodCapability;
import team.creative.solonion.api.SOLOnionAPI;
import team.creative.solonion.common.SOLOnion;
import team.creative.solonion.common.benefit.BenefitPlayerDataImpl;
import team.creative.solonion.common.benefit.BenefitStack;
import team.creative.solonion.common.benefit.BenefitThreshold;
import team.creative.solonion.common.food.FoodCapabilityImpl;
import team.creative.solonion.common.item.foodcontainer.FoodContainerItem;
import team.creative.solonion.common.network.FoodListMessage;

public class SOLOnionEvent {
    public void updatePlayerBenefits(Player player) {
        if (!SOLOnion.isActive(player) || !player.m_6084_()) {
            return;
        }
        this.updateBenefits(player);
    }

    private void updateBenefits(Player player) {
        if (player.m_20193_().f_46443_) {
            return;
        }
        FoodCapability foodList = SOLOnionAPI.getFoodCapability(player);
        if (foodList.trackCount() < SOLOnion.CONFIG.minFoodsToActivate) {
            return;
        }
        BenefitStack stack = new BenefitStack();
        double d = foodList.foodDiversity((LivingEntity)player);
        for (BenefitThreshold threshold : SOLOnion.CONFIG.benefits) {
            if (!(threshold.threshold <= d)) break;
            stack.add(threshold.benefit);
        }
        SOLOnionAPI.getBenefitCapability(player).updateStack(player, stack);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.updatePlayerBenefits(event.getEntity());
        this.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        event.addCapability(SOLOnionAPI.FOOD, (ICapabilityProvider)new FoodCapabilityImpl());
        event.addCapability(SOLOnionAPI.BENEFIT, (ICapabilityProvider)new BenefitPlayerDataImpl());
    }

    @SubscribeEvent
    public void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.syncFoodList(event.getEntity());
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && SOLOnion.CONFIG.resetOnDeath) {
            return;
        }
        Player originalPlayer = event.getOriginal();
        originalPlayer.reviveCaps();
        FoodCapability original = SOLOnionAPI.getFoodCapability(originalPlayer);
        FoodCapability newInstance = SOLOnionAPI.getFoodCapability(event.getEntity());
        newInstance.deserializeNBT((Tag)((ListTag)original.serializeNBT()));
        BenefitCapability originalB = SOLOnionAPI.getBenefitCapability(originalPlayer);
        BenefitCapability newInstanceB = SOLOnionAPI.getBenefitCapability(event.getEntity());
        newInstanceB.deserializeNBT((Tag)((CompoundTag)originalB.serializeNBT()));
        originalPlayer.invalidateCaps();
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.updatePlayerBenefits(event.getEntity());
        this.syncFoodList(event.getEntity());
    }

    public void syncFoodList(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        SOLOnion.NETWORK.sendToClient((CreativePacket)new FoodListMessage(SOLOnionAPI.getFoodCapability(player)), (ServerPlayer)player);
    }

    @SubscribeEvent
    public void onFoodEaten(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        if (!SOLOnion.isActive(player)) {
            return;
        }
        ItemStack usedItem = event.getItem();
        if (!usedItem.m_41614_() && usedItem.m_41720_() != Items.f_42502_) {
            return;
        }
        if (usedItem.m_41720_() instanceof FoodContainerItem) {
            return;
        }
        this.eat(usedItem, player);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onCakeBlockEaten(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        BlockState state = event.getLevel().m_8055_(event.getPos());
        Block clickedBlock = state.m_60734_();
        Player player = event.getEntity();
        Item eatenItem = Items.f_42502_;
        if (ModList.get().isLoaded("farmersdelight")) {
            eatenItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("farmersdelight:cake_slice"));
        }
        ItemStack eatenItemStack = new ItemStack((ItemLike)eatenItem);
        if (clickedBlock == Blocks.f_50145_ && player.m_36391_(false) && event.getHand() == InteractionHand.MAIN_HAND && !event.getLevel().f_46443_) {
            ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)eatenItemStack, (int)0, (ItemStack)ItemStack.f_41583_);
        }
    }

    public void eat(ItemStack food, Player player) {
        FoodCapability foodList = SOLOnionAPI.getFoodCapability(player);
        foodList.eat((LivingEntity)player, food);
        this.updatePlayerBenefits(player);
        this.syncFoodList(player);
    }
}

