/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank;

import com.simibubi.create.foundation.utility.Components;
import dev.ithundxr.createnumismatics.util.UsernameUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IDCardItem
extends Item {
    public final DyeColor color;

    public IDCardItem(Item.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
    }

    public static ItemStack clear(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return itemStack;
        }
        CompoundTag tag = itemStack.m_41783_();
        tag.m_128473_("UUID");
        itemStack.m_41751_(tag);
        return itemStack;
    }

    public static ItemStack set(ItemStack itemStack, UUID id) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128362_("UUID", id);
        itemStack.m_41751_(tag);
        return itemStack;
    }

    @Nullable
    public static UUID get(ItemStack itemStack) {
        if (!IDCardItem.isBound(itemStack)) {
            return null;
        }
        CompoundTag tag = itemStack.m_41783_();
        return tag.m_128342_("UUID");
    }

    @Nullable
    public static String getPlayerName(ItemStack itemStack) {
        if (!IDCardItem.isBound(itemStack)) {
            return null;
        }
        return UsernameUtils.INSTANCE.getName(IDCardItem.get(itemStack));
    }

    public static boolean isBound(ItemStack itemStack) {
        return itemStack.m_41782_() && itemStack.m_41783_().m_128403_("UUID");
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, @NotNull InteractionHand usedHand) {
        ItemStack handStack = player.m_21120_(usedHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)handStack);
        }
        if (IDCardItem.isBound(handStack)) {
            if (player.m_6144_()) {
                IDCardItem.clear(handStack);
                player.m_5661_((Component)Components.translatable((String)"item.numismatics.id_card.tooltip.cleared"), true);
                return InteractionResultHolder.m_19090_((Object)handStack);
            }
            player.m_5661_((Component)Components.translatable((String)"item.numismatics.id_card.tooltip.already_bound").m_130940_(ChatFormatting.RED), true);
        } else if (!player.m_6144_()) {
            IDCardItem.set(handStack, player.m_20148_());
            player.m_5661_((Component)Components.translatable((String)"item.numismatics.id_card.tooltip.bound"), true);
            return InteractionResultHolder.m_19090_((Object)handStack);
        }
        return InteractionResultHolder.m_19098_((Object)handStack);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (IDCardItem.isBound(stack)) {
            tooltipComponents.add((Component)Components.translatable((String)"item.numismatics.card.tooltip.bound.to", (Object[])new Object[]{IDCardItem.getPlayerName(stack)}).m_130940_(ChatFormatting.GREEN));
        } else {
            tooltipComponents.add((Component)Components.translatable((String)"item.numismatics.card.tooltip.blank"));
        }
    }
}

