/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.bank.blaze_banker;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;

public class BankAccountBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<BankAccountBehaviour> TYPE = new BehaviourType();
    private UUID accountUUID;

    public BankAccountBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public UUID getAccountUUID() {
        if (this.accountUUID == null) {
            this.accountUUID = UUID.randomUUID();
            this.blockEntity.notifyUpdate();
        }
        return this.accountUUID;
    }

    public BankAccount getAccount() {
        return Numismatics.BANK.getOrCreateAccount(this.getAccountUUID(), BankAccount.Type.BLAZE_BANKER);
    }

    public boolean hasAccount() {
        if (this.accountUUID == null) {
            return false;
        }
        return Numismatics.BANK.getAccount(this.accountUUID) != null;
    }

    public void read(CompoundTag nbt, boolean clientPacket) {
        super.read(nbt, clientPacket);
        if (nbt.m_128403_("accountUUID")) {
            this.accountUUID = nbt.m_128342_("accountUUID");
        }
    }

    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        if (this.accountUUID != null) {
            nbt.m_128362_("accountUUID", this.accountUUID);
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void destroy() {
        super.destroy();
        BankAccount oldAccount = Numismatics.BANK.accounts.remove(this.accountUUID);
        if (oldAccount != null) {
            oldAccount.setLabel(null);
        }
        Numismatics.BANK.markBankDirty();
    }
}

