/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.content.backend.BankAccount;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.Trusted;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListContainer;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListHolder;
import dev.ithundxr.createnumismatics.content.bank.CardItem;
import dev.ithundxr.createnumismatics.content.coins.DiscreteCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlock;
import dev.ithundxr.createnumismatics.registry.NumismaticsPackets;
import dev.ithundxr.createnumismatics.registry.NumismaticsTags;
import dev.ithundxr.createnumismatics.registry.packets.OpenTrustListPacket;
import dev.ithundxr.createnumismatics.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDepositorBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation,
Trusted,
TrustListHolder {
    public final Container cardContainer = new SimpleContainer(1){

        public void m_6596_() {
            super.m_6596_();
            AbstractDepositorBlockEntity.this.m_6596_();
        }
    };
    @Nullable
    protected UUID owner;
    protected final List<UUID> trustList = new ArrayList<UUID>();
    public final TrustListContainer trustListContainer = new TrustListContainer(this.trustList, () -> ((AbstractDepositorBlockEntity)this).m_6596_());
    protected final DiscreteCoinBag inventory = new DiscreteCoinBag();
    private boolean delayedDataSync = false;

    public AbstractDepositorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Nullable
    public UUID getCardId() {
        ItemStack card = this.cardContainer.m_8020_(0);
        if (!(card.m_41720_() instanceof CardItem)) {
            return null;
        }
        return CardItem.get(card);
    }

    public void activate() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = this.m_58900_().m_60734_();
            if (block instanceof AbstractDepositorBlock) {
                AbstractDepositorBlock depositorBlock = (AbstractDepositorBlock)block;
                depositorBlock.activate(this.m_58900_(), serverLevel, this.f_58858_);
            }
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        if (!this.inventory.isEmpty()) {
            tag.m_128365_("Inventory", (Tag)this.inventory.save(new CompoundTag()));
        }
        if (!this.cardContainer.m_8020_(0).m_41619_()) {
            tag.m_128365_("Card", (Tag)this.cardContainer.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.trustListContainer.m_7983_()) {
            tag.m_128365_("TrustListInv", (Tag)this.trustListContainer.save(new CompoundTag()));
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.owner = tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null;
        this.inventory.clear();
        if (tag.m_128425_("Inventory", 10)) {
            this.inventory.load(tag.m_128469_("Inventory"));
        }
        if (tag.m_128425_("Card", 10)) {
            ItemStack cardStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Card"));
            this.cardContainer.m_6836_(0, cardStack);
        } else {
            this.cardContainer.m_6836_(0, ItemStack.f_41583_);
        }
        this.trustListContainer.m_6211_();
        this.trustList.clear();
        if (tag.m_128425_("TrustListInv", 10)) {
            this.trustListContainer.load(tag.m_128469_("TrustListInv"));
        }
    }

    @Override
    public boolean isTrustedInternal(Player player) {
        if (Utils.isDevEnv()) {
            return player.m_6844_(EquipmentSlot.FEET).m_150930_(Items.f_42479_);
        }
        return this.owner == null || this.owner.equals(player.m_20148_()) || this.trustList.contains(player.m_20148_());
    }

    @Nullable
    public UUID getDepositAccount() {
        ItemStack cardStack = this.cardContainer.m_8020_(0);
        if (cardStack.m_41619_()) {
            return null;
        }
        if (!NumismaticsTags.AllItemTags.CARDS.matches(cardStack)) {
            return null;
        }
        return CardItem.get(cardStack);
    }

    public void addCoin(Coin coin, int count) {
        BankAccount account;
        UUID depositAccount = this.getDepositAccount();
        if (depositAccount != null && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            account.deposit(coin, count);
            return;
        }
        this.inventory.add(coin, count);
        this.m_6596_();
    }

    public void lazyTick() {
        BankAccount account;
        UUID depositAccount;
        super.lazyTick();
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.delayedDataSync) {
            this.delayedDataSync = false;
            this.sendData();
        }
        if ((depositAccount = this.getDepositAccount()) != null && !this.inventory.isEmpty() && (account = Numismatics.BANK.getAccount(depositAccount)) != null) {
            for (Coin coin : Coin.values()) {
                int count = this.inventory.getDiscrete(coin);
                this.inventory.subtract(coin, count);
                account.deposit(coin, count);
                this.notifyUpdate();
            }
        }
    }

    void notifyDelayedDataSync() {
        this.delayedDataSync = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openTrustList() {
        if (this.f_58857_ == null || !this.f_58857_.f_46443_) {
            return;
        }
        NumismaticsPackets.PACKETS.send(new OpenTrustListPacket<AbstractDepositorBlockEntity>(this));
    }

    @Override
    public ImmutableList<UUID> getTrustList() {
        return ImmutableList.copyOf(this.trustList);
    }

    @Override
    public Container getTrustListBackingContainer() {
        return this.trustListContainer;
    }
}

