/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.content.depositor;

import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Lang;
import dev.ithundxr.createnumismatics.content.backend.Coin;
import dev.ithundxr.createnumismatics.content.backend.behaviours.SliderStylePriceBehaviour;
import dev.ithundxr.createnumismatics.content.backend.trust_list.TrustListMenu;
import dev.ithundxr.createnumismatics.content.coins.MergingCoinBag;
import dev.ithundxr.createnumismatics.content.depositor.AbstractDepositorBlockEntity;
import dev.ithundxr.createnumismatics.content.depositor.BrassDepositorMenu;
import dev.ithundxr.createnumismatics.registry.NumismaticsBlocks;
import dev.ithundxr.createnumismatics.registry.NumismaticsMenuTypes;
import dev.ithundxr.createnumismatics.util.TextUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrassDepositorBlockEntity
extends AbstractDepositorBlockEntity
implements MenuProvider {
    private SliderStylePriceBehaviour price;

    public BrassDepositorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.price = new SliderStylePriceBehaviour(this, this::addCoin, this::getCoinCount);
        behaviours.add(this.price);
    }

    public int getCoinCount(Coin coin) {
        return this.inventory.getDiscrete(coin);
    }

    @NotNull
    public Component m_5446_() {
        return Components.translatable((String)"block.numismatics.brass_depositor");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, @NotNull Inventory inventory, @NotNull Player player) {
        if (!this.isTrusted(player)) {
            return null;
        }
        return new BrassDepositorMenu((MenuType)NumismaticsMenuTypes.BRASS_DEPOSITOR.get(), i, inventory, this);
    }

    public int getTotalPrice() {
        return this.price.getTotalPrice();
    }

    public int getPrice(Coin coin) {
        return this.price.getPrice(coin);
    }

    public void setPrice(Coin coin, int price) {
        this.price.setPrice(coin, price);
    }

    public void addCoins(int totalPrice) {
        MergingCoinBag coinBag = new MergingCoinBag(totalPrice);
        for (int i = Coin.values().length - 1; i >= 0; --i) {
            Coin coin = Coin.values()[i];
            int count = (Integer)coinBag.get(coin).getFirst();
            if (count <= 0) continue;
            coinBag.subtract(coin, count);
            this.addCoin(coin, count);
        }
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Couple<Integer> cogsAndSpurs = Coin.COG.convert(this.price.getTotalPrice());
        int cogs = (Integer)cogsAndSpurs.getFirst();
        int spurs = (Integer)cogsAndSpurs.getSecond();
        MutableComponent balanceLabel = Components.translatable((String)"block.numismatics.brass_depositor.tooltip.price", (Object[])new Object[]{TextUtils.formatInt(cogs), Coin.COG.getName(cogs), spurs});
        Lang.builder().add(balanceLabel.m_130940_(Coin.closest((int)this.price.getTotalPrice()).rarity.f_43022_)).forGoggles(tooltip);
        for (MutableComponent component : this.price.getCondensedPriceBreakdown()) {
            Lang.builder().add(component).forGoggles(tooltip);
        }
        return true;
    }

    @Override
    public void openTrustListMenu(ServerPlayer player) {
        TrustListMenu.openMenu(this, player, NumismaticsBlocks.BRASS_DEPOSITOR.asStack());
    }
}

