/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.advancement;

import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import dev.ithundxr.createnumismatics.Numismatics;
import dev.ithundxr.createnumismatics.registry.NumismaticsAdvancements;
import dev.ithundxr.createnumismatics.registry.NumismaticsTriggers;
import dev.ithundxr.createnumismatics.registry.advancement.SimpleNumismaticsTrigger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.ApiStatus;

public class NumismaticsAdvancement {
    static final ResourceLocation BACKGROUND = Numismatics.asResource("textures/gui/advancements.png");
    static final String LANG = "advancement.numismatics.";
    static final String SECRET_SUFFIX = "\n\u00a77(Hidden Advancement)";
    private Advancement.Builder builder = Advancement.Builder.m_138353_();
    private SimpleNumismaticsTrigger builtinTrigger;
    private NumismaticsAdvancement parent;
    Advancement datagenResult;
    private String id;
    private String title;
    private String description;

    public NumismaticsAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder t = new Builder();
        b.apply(t);
        if (!t.externalTrigger) {
            this.builtinTrigger = NumismaticsTriggers.addSimple(id + "_builtin");
            this.builder.m_138386_("0", (CriterionTriggerInstance)this.builtinTrigger.instance());
        }
        this.builder.m_138362_(t.icon, (Component)Components.translatable((String)this.titleKey()), (Component)Components.translatable((String)this.descriptionKey()).m_130938_(s -> s.m_178520_(14393875)), (ResourceLocation)(id.equals("root") ? BACKGROUND : null), t.type.frame, t.type.toast, t.type.announce, t.type.hide);
        if (t.type == TaskType.SECRET) {
            this.description = this.description + SECRET_SUFFIX;
        }
        NumismaticsAdvancements.ENTRIES.add(this);
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public boolean isAlreadyAwardedTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(Numismatics.asResource(this.id));
        if (advancement == null) {
            return true;
        }
        return sp.m_8960_().m_135996_(advancement).m_8193_();
    }

    public void awardTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    @ApiStatus.Internal
    public void save(Consumer<Advancement> t) {
        if (this.parent != null) {
            this.builder.m_138398_(this.parent.datagenResult);
        }
        this.datagenResult = this.builder.m_138389_(t, Numismatics.asResource(this.id).toString());
    }

    @ApiStatus.Internal
    public void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    @ApiStatus.Internal
    public class Builder {
        private TaskType type = TaskType.NORMAL;
        private boolean externalTrigger;
        private int keyIndex;
        private ItemStack icon;

        @ApiStatus.Internal
        public Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        @ApiStatus.Internal
        public Builder after(NumismaticsAdvancement other) {
            NumismaticsAdvancement.this.parent = other;
            return this;
        }

        @ApiStatus.Internal
        public Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        @ApiStatus.Internal
        public Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        @ApiStatus.Internal
        public Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        @ApiStatus.Internal
        public Builder title(String title) {
            NumismaticsAdvancement.this.title = title;
            return this;
        }

        @ApiStatus.Internal
        public Builder description(String description) {
            NumismaticsAdvancement.this.description = description;
            return this;
        }

        @ApiStatus.Internal
        public Builder whenBlockPlaced(Block block) {
            return this.externalTrigger((CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)block));
        }

        @ApiStatus.Internal
        public Builder whenIconCollected() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{this.icon.m_41720_()}));
        }

        @ApiStatus.Internal
        public Builder whenItemCollected(ItemProviderEntry<?> item) {
            return this.whenItemCollected((ItemLike)item.asStack().m_41720_());
        }

        @ApiStatus.Internal
        public Builder whenItemCollected(ItemLike itemProvider) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemProvider}));
        }

        @ApiStatus.Internal
        public Builder whenItemCollected(TagKey<Item> tag) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)}));
        }

        @ApiStatus.Internal
        public Builder awardedForFree() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0]));
        }

        @ApiStatus.Internal
        public Builder externalTrigger(CriterionTriggerInstance trigger) {
            NumismaticsAdvancement.this.builder.m_138386_(String.valueOf(this.keyIndex), trigger);
            this.externalTrigger = true;
            ++this.keyIndex;
            return this;
        }
    }

    @ApiStatus.Internal
    public static enum TaskType {
        SILENT(FrameType.TASK, false, false, false),
        NORMAL(FrameType.TASK, true, false, false),
        NOISY(FrameType.TASK, true, true, false),
        EXPERT(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true);

        private FrameType frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

