/*
 * Decompiled with CFR 0.152.
 */
package dev.ithundxr.createnumismatics.registry.packets;

import dev.ithundxr.createnumismatics.content.vendor.VendorMenu;
import dev.ithundxr.createnumismatics.multiloader.S2CPacket;
import dev.ithundxr.createnumismatics.util.PacketUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class VendorContainerSetSlotPacket
implements S2CPacket {
    private final int containerId;
    private final int stateId;
    private final int slot;
    private final ItemStack itemStack;

    public VendorContainerSetSlotPacket(int containerId, int stateId, int slot, ItemStack itemStack) {
        this.containerId = containerId;
        this.stateId = stateId;
        this.slot = slot;
        this.itemStack = itemStack;
    }

    public VendorContainerSetSlotPacket(FriendlyByteBuf buffer) {
        this.containerId = buffer.readUnsignedByte();
        this.stateId = buffer.m_130242_();
        this.slot = buffer.readShort();
        this.itemStack = PacketUtils.readHighCountItem(buffer);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeByte(this.containerId);
        buffer.m_130130_(this.stateId);
        buffer.writeShort(this.slot);
        PacketUtils.writeHighCountItem(buffer, this.itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        if (player.f_36096_ != null && player.f_36096_ instanceof VendorMenu && player.f_36096_.f_38840_ == this.containerId) {
            player.f_36096_.m_182406_(this.slot, this.stateId, this.itemStack);
        }
    }
}

