/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.hopper;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import me.jellysquid.mods.lithium.api.inventory.LithiumInventory;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeEmitter;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeListener;
import me.jellysquid.mods.lithium.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import me.jellysquid.mods.lithium.common.block.entity.inventory_comparator_tracking.ComparatorTracker;
import me.jellysquid.mods.lithium.common.hopper.InventoryHelper;
import me.jellysquid.mods.lithium.common.hopper.LithiumDoubleStackList;
import me.jellysquid.mods.lithium.common.hopper.LithiumStackList;
import me.jellysquid.mods.lithium.mixin.block.hopper.DoubleInventoryAccessor;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class LithiumDoubleInventory
extends CompoundContainer
implements LithiumInventory,
InventoryChangeTracker,
InventoryChangeEmitter,
InventoryChangeListener,
ComparatorTracker {
    private final LithiumInventory first;
    private final LithiumInventory second;
    private LithiumStackList doubleStackList;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = null;
    ReferenceOpenHashSet<InventoryChangeListener> inventoryHandlingTypeListeners = null;

    public static LithiumDoubleInventory getLithiumInventory(CompoundContainer doubleInventory) {
        Container vanillaSecond;
        Container vanillaFirst = ((DoubleInventoryAccessor)doubleInventory).getFirst();
        if (vanillaFirst != (vanillaSecond = ((DoubleInventoryAccessor)doubleInventory).getSecond()) && vanillaFirst instanceof LithiumInventory) {
            LithiumInventory first = (LithiumInventory)vanillaFirst;
            if (vanillaSecond instanceof LithiumInventory) {
                LithiumInventory second = (LithiumInventory)vanillaSecond;
                LithiumDoubleInventory newDoubleInventory = new LithiumDoubleInventory(first, second);
                LithiumDoubleStackList doubleStackList = LithiumDoubleStackList.getOrCreate(newDoubleInventory, InventoryHelper.getLithiumStackList(first), InventoryHelper.getLithiumStackList(second), newDoubleInventory.m_6893_());
                newDoubleInventory.doubleStackList = doubleStackList;
                return doubleStackList.doubleInventory;
            }
        }
        return null;
    }

    private LithiumDoubleInventory(LithiumInventory first, LithiumInventory second) {
        super((Container)first, (Container)second);
        this.first = first;
        this.second = second;
    }

    @Override
    public void emitContentModified() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null) {
            for (InventoryChangeListener inventoryChangeListener : inventoryChangeListeners) {
                inventoryChangeListener.handleInventoryContentModified(this);
            }
            inventoryChangeListeners.clear();
        }
    }

    @Override
    public void emitStackListReplaced() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(inventoryChangeListener -> inventoryChangeListener.handleStackListReplaced(this));
        }
        this.invalidateChangeListening();
    }

    @Override
    public void emitRemoved() {
        ReferenceOpenHashSet<InventoryChangeListener> listeners = this.inventoryHandlingTypeListeners;
        if (listeners != null && !listeners.isEmpty()) {
            listeners.forEach(listener -> listener.handleInventoryRemoved(this));
        }
        this.invalidateChangeListening();
    }

    private void invalidateChangeListening() {
        LithiumStackList lithiumStackList;
        if (this.inventoryChangeListeners != null) {
            this.inventoryChangeListeners.clear();
        }
        if ((lithiumStackList = InventoryHelper.getLithiumStackListOrNull(this)) != null) {
            lithiumStackList.removeInventoryModificationCallback(this);
        }
    }

    @Override
    public void emitFirstComparatorAdded() {
        ReferenceOpenHashSet<InventoryChangeListener> inventoryChangeListeners = this.inventoryChangeListeners;
        if (inventoryChangeListeners != null && !inventoryChangeListeners.isEmpty()) {
            inventoryChangeListeners.removeIf(inventoryChangeListener -> inventoryChangeListener.handleComparatorAdded(this));
        }
    }

    @Override
    public void forwardContentChangeOnce(InventoryChangeListener inventoryChangeListener, LithiumStackList stackList, InventoryChangeTracker thisTracker) {
        if (this.inventoryChangeListeners == null) {
            this.inventoryChangeListeners = new ReferenceOpenHashSet(1);
        }
        stackList.setInventoryModificationCallback(thisTracker);
        this.inventoryChangeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void forwardMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners == null) {
            this.inventoryHandlingTypeListeners = new ReferenceOpenHashSet(1);
            ((InventoryChangeTracker)((Object)this.first)).listenForMajorInventoryChanges(this);
            ((InventoryChangeTracker)((Object)this.second)).listenForMajorInventoryChanges(this);
        }
        this.inventoryHandlingTypeListeners.add((Object)inventoryChangeListener);
    }

    @Override
    public void stopForwardingMajorInventoryChanges(InventoryChangeListener inventoryChangeListener) {
        if (this.inventoryHandlingTypeListeners != null) {
            this.inventoryHandlingTypeListeners.remove((Object)inventoryChangeListener);
            if (this.inventoryHandlingTypeListeners.isEmpty()) {
                ((InventoryChangeTracker)((Object)this.first)).stopListenForMajorInventoryChanges(this);
                ((InventoryChangeTracker)((Object)this.second)).stopListenForMajorInventoryChanges(this);
            }
        }
    }

    @Override
    public NonNullList<ItemStack> getInventoryLithium() {
        return this.doubleStackList;
    }

    @Override
    public void setInventoryLithium(NonNullList<ItemStack> inventory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void handleInventoryContentModified(Container inventory) {
        this.emitContentModified();
    }

    @Override
    public void handleInventoryRemoved(Container inventory) {
        this.emitRemoved();
    }

    @Override
    public boolean handleComparatorAdded(Container inventory) {
        this.emitFirstComparatorAdded();
        return this.inventoryChangeListeners.isEmpty();
    }

    @Override
    public void onComparatorAdded(Direction direction, int offset) {
        throw new UnsupportedOperationException("Call onComparatorAdded(Direction direction, int offset) on the inventory half only!");
    }

    @Override
    public boolean hasAnyComparatorNearby() {
        return ((ComparatorTracker)((Object)this.first)).hasAnyComparatorNearby() || ((ComparatorTracker)((Object)this.second)).hasAnyComparatorNearby();
    }
}

