/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.util.entity_movement_tracking;

import me.jellysquid.mods.lithium.common.entity.movement_tracker.EntityMovementTrackerSection;
import me.jellysquid.mods.lithium.common.entity.movement_tracker.MovementTrackerHelper;
import me.jellysquid.mods.lithium.common.entity.movement_tracker.ToggleableMovementTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(targets={"net/minecraft/server/world/ServerEntityManager$Listener"})
public class ServerEntityManagerListenerMixin<T extends EntityAccess>
implements ToggleableMovementTracker {
    @Shadow
    private EntitySection<T> f_157611_;
    @Shadow
    @Final
    private T f_157609_;
    private int notificationMask;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(PersistentEntitySectionManager<?> outer, T entityLike, long l, EntitySection<T> entityTrackingSection, CallbackInfo ci) {
        this.notificationMask = MovementTrackerHelper.getNotificationMask(this.f_157609_.getClass());
        this.notifyMovementListeners();
    }

    @Inject(method={"updateEntityPosition()V"}, at={@At(value="RETURN")})
    private void updateEntityTrackerEngine(CallbackInfo ci) {
        this.notifyMovementListeners();
    }

    @Inject(method={"updateEntityPosition()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/EntityTrackingSection;add(Lnet/minecraft/world/entity/EntityLike;)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void onAddEntity(CallbackInfo ci, BlockPos blockPos, long newPos, Visibility entityTrackingStatus, EntitySection<T> entityTrackingSection) {
        this.notifyMovementListeners();
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void onRemoveEntity(Entity.RemovalReason reason, CallbackInfo ci) {
        this.notifyMovementListeners();
    }

    private void notifyMovementListeners() {
        if (this.notificationMask != 0) {
            ((EntityMovementTrackerSection)this.f_157611_).trackEntityMovement(this.notificationMask, ((Entity)this.f_157609_).m_20193_().m_46467_());
        }
    }

    @Override
    public int setNotificationMask(int notificationMask) {
        int oldNotificationMask = this.notificationMask;
        this.notificationMask = notificationMask;
        return oldNotificationMask;
    }
}

