/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexSorting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.common.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.render.MinimapRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconManager;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.compass.render.CompassRenderer;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.map.MinimapElementMapRendererHandler;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.render.WaypointsGuiRenderer;

public class MinimapFBORenderer
extends MinimapRenderer {
    private ImprovedFramebuffer scalingFramebuffer;
    private ImprovedFramebuffer rotationFramebuffer;
    private MinimapElementMapRendererHandler minimapElementMapRendererHandler;
    private RadarRenderer radarRenderer;
    private EntityIconManager entityIconManager;
    private boolean triedFBO;
    private boolean loadedFBO;

    public MinimapFBORenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer, Minimap minimap, CompassRenderer compassRenderer) {
        super(modMain, mc, waypointsGuiRenderer, minimap, compassRenderer);
    }

    public void loadFrameBuffer(MinimapProcessor minimapProcessor) {
        if (!minimapProcessor.canUseFrameBuffer()) {
            MinimapLogs.LOGGER.info("FBO mode not supported! Using minimap safe mode.");
        } else {
            this.scalingFramebuffer = new ImprovedFramebuffer(512, 512, false);
            this.rotationFramebuffer = new ImprovedFramebuffer(512, 512, true);
            this.rotationFramebuffer.m_83936_(9729);
            this.entityIconManager = new EntityIconManager(this.modMain, new EntityIconPrerenderer(this.modMain));
            this.loadedFBO = this.scalingFramebuffer.f_83920_ != -1 && this.rotationFramebuffer.f_83920_ != -1;
            this.minimapElementMapRendererHandler = MinimapElementMapRendererHandler.Builder.begin().build();
            this.radarRenderer = RadarRenderer.Builder.begin().setModMain(this.modMain).setEntityIconManager(this.entityIconManager).setMinimap(this.minimap).build();
            this.minimapElementMapRendererHandler.add(this.radarRenderer);
            this.minimap.getOverMapRendererHandler().add(this.radarRenderer);
            if (this.modMain.getSupportMods().worldmap()) {
                this.modMain.getSupportMods().worldmapSupport.createRadarRenderWrapper(this.radarRenderer);
            }
        }
        this.triedFBO = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderChunks(MinimapSession minimapSession, GuiGraphics guiGraphics, MinimapProcessor minimap, Vec3 renderPos, double playerDimDiv, double mapDimensionScale, int mapSize, int bufferSize, float sizeFix, float partial, int lightLevel, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, ModSettings settings, CustomVertexConsumers cvc) {
        MinimapWriter minimapWriter = minimap.getMinimapWriter();
        synchronized (minimapWriter) {
            this.renderChunksToFBO(minimapSession, guiGraphics, minimap, (Player)this.mc.f_91074_, this.mc.m_91288_(), renderPos, playerDimDiv, mapDimensionScale, bufferSize, mapSize, sizeFix, partial, lightLevel, true, useWorldMap, lockedNorth, shape, ps, pc, cave, circle, cvc);
        }
        this.scalingFramebuffer.bindDefaultFramebuffer(Minecraft.m_91087_());
        GlStateManager._viewport((int)0, (int)0, (int)Minecraft.m_91087_().m_91268_().m_85441_(), (int)Minecraft.m_91087_().m_91268_().m_85442_());
        this.rotationFramebuffer.m_83956_();
    }

    public void renderChunksToFBO(MinimapSession minimapSession, GuiGraphics guiGraphics, MinimapProcessor minimap, Player player, Entity renderEntity, Vec3 renderPos, double playerDimDiv, double mapDimensionScale, int bufferSize, int viewW, float sizeFix, float partial, int level, boolean retryIfError, boolean useWorldMap, boolean lockedNorth, int shape, double ps, double pc, boolean cave, boolean circle, CustomVertexConsumers cvc) {
        int drawX;
        double zInsidePixel;
        Matrix4f projectionMatrixBackup = RenderSystem.getProjectionMatrix();
        VertexSorting vertexSortingBackup = RenderSystem.getVertexSorting();
        PoseStack matrixStack = guiGraphics.m_280168_();
        MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers = minimapSession.getMultiTextureRenderTypeRenderers();
        double maxVisibleLength = lockedNorth || shape == 1 ? (double)viewW : (double)viewW * Math.sqrt(2.0);
        double halfMaxVisibleLength = maxVisibleLength / 2.0;
        double radiusBlocks = maxVisibleLength / 2.0 / this.zoom;
        int xFloored = OptimizedMath.myFloor(renderPos.f_82479_);
        int zFloored = OptimizedMath.myFloor(renderPos.f_82481_);
        int playerChunkX = xFloored >> 6;
        int playerChunkZ = zFloored >> 6;
        int offsetX = xFloored & 0x3F;
        int offsetZ = zFloored & 0x3F;
        boolean zooming = (double)((int)this.zoom) != this.zoom;
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(guiGraphics);
        this.scalingFramebuffer.m_83947_(true);
        GL11.glClear((int)16640);
        Lighting.m_84930_();
        long before = System.currentTimeMillis();
        GlStateManager._clear((int)256, (boolean)Minecraft.f_91002_);
        this.helper.defaultOrtho((RenderTarget)this.scalingFramebuffer);
        PoseStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        before = System.currentTimeMillis();
        double xInsidePixel = renderPos.f_82479_ - (double)xFloored;
        if (xInsidePixel < 0.0) {
            xInsidePixel += 1.0;
        }
        if ((zInsidePixel = renderPos.f_82481_ - (double)zFloored) < 0.0) {
            zInsidePixel += 1.0;
        }
        float halfWView = (float)viewW / 2.0f;
        float angle = (float)(90.0 - this.getRenderAngle(lockedNorth));
        RenderSystem.enableBlend();
        shaderMatrixStack.m_252880_(256.0f, 256.0f, -2000.0f);
        shaderMatrixStack.m_85841_((float)this.zoom, (float)this.zoom, 1.0f);
        RenderSystem.applyModelViewMatrix();
        guiGraphics.m_280509_(-256, -256, 256, 256, -16777216);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MultiBufferSource.BufferSource renderTypeBuffers = cvc.getBetterPVPRenderTypeBuffers();
        VertexConsumer overlayBufferBuilder = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_CHUNK_OVERLAY);
        float chunkGridAlphaMultiplier = 1.0f;
        int minX = playerChunkX + (int)Math.floor(((double)offsetX - radiusBlocks) / 64.0);
        int minZ = playerChunkZ + (int)Math.floor(((double)offsetZ - radiusBlocks) / 64.0);
        int maxX = playerChunkX + (int)Math.floor(((double)(offsetX + 1) + radiusBlocks) / 64.0);
        int maxZ = playerChunkZ + (int)Math.floor(((double)(offsetZ + 1) + radiusBlocks) / 64.0);
        if (!cave || !Misc.hasEffect((Player)this.mc.f_91074_, Effects.NO_CAVE_MAPS) && !Misc.hasEffect((Player)this.mc.f_91074_, Effects.NO_CAVE_MAPS_HARMFUL)) {
            if (useWorldMap) {
                chunkGridAlphaMultiplier = this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
                this.modMain.getSupportMods().worldmapSupport.drawMinimap(minimapSession, matrixStack, this.getHelper(), xFloored, zFloored, minX, minZ, maxX, maxZ, zooming, this.zoom, mapDimensionScale, overlayBufferBuilder, multiTextureRenderTypeRenderers);
            } else if (minimap.getMinimapWriter().getLoadedBlocks() != null && level >= 0) {
                int loadedLevels = minimap.getMinimapWriter().getLoadedLevels();
                chunkGridAlphaMultiplier = loadedLevels <= 1 ? 1.0f : 0.375f + 0.625f * (1.0f - (float)level / (float)(loadedLevels - 1));
                int loadedMapChunkX = minimap.getMinimapWriter().getLoadedMapChunkX();
                int loadedMapChunkZ = minimap.getMinimapWriter().getLoadedMapChunkZ();
                int loadedWidth = minimap.getMinimapWriter().getLoadedBlocks().length;
                boolean slimeChunks = this.modMain.getSettings().getSlimeChunks(minimapSession);
                minX = Math.max(minX, loadedMapChunkX);
                minZ = Math.max(minZ, loadedMapChunkZ);
                maxX = Math.min(maxX, loadedMapChunkX + loadedWidth - 1);
                maxZ = Math.min(maxZ, loadedMapChunkZ + loadedWidth - 1);
                MultiTextureRenderTypeRenderer multiTextureRenderTypeRenderer = multiTextureRenderTypeRenderers.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR);
                MinimapRendererHelper helper = this.getHelper();
                for (int X = minX; X <= maxX; ++X) {
                    int canvasX = X - minimap.getMinimapWriter().getLoadedMapChunkX();
                    for (int Z = minZ; Z <= maxZ; ++Z) {
                        int canvasZ = Z - minimap.getMinimapWriter().getLoadedMapChunkZ();
                        MinimapChunk mchunk = minimap.getMinimapWriter().getLoadedBlocks()[canvasX][canvasZ];
                        if (mchunk == null) continue;
                        int texture = mchunk.bindTexture(level);
                        if (!mchunk.isHasSomething() || level >= mchunk.getLevelsBuffered() || texture == 0) continue;
                        if (!zooming) {
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                        } else {
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                        }
                        drawX = (X - playerChunkX) * 64 - offsetX;
                        int drawZ = (Z - playerChunkZ) * 64 - offsetZ;
                        helper.prepareMyTexturedColoredModalRect(matrixStack.m_85850_().m_252922_(), drawX, drawZ, 0, 64, 64.0f, 64.0f, -64.0f, 64.0f, texture, 1.0f, 1.0f, 1.0f, 1.0f, multiTextureRenderTypeRenderer);
                        if (!slimeChunks) continue;
                        for (int t2 = 0; t2 < 16; ++t2) {
                            if (mchunk.getTile(t2 % 4, t2 / 4) == null || !mchunk.getTile(t2 % 4, t2 / 4).isSlimeChunk()) continue;
                            int slimeDrawX = drawX + 16 * (t2 % 4);
                            int slimeDrawZ = drawZ + 16 * (t2 / 4);
                            helper.addColoredRectToExistingBuffer(matrixStack.m_85850_().m_252922_(), overlayBufferBuilder, slimeDrawX, slimeDrawZ, 16, 16, -2142047936);
                        }
                    }
                }
                multiTextureRenderTypeRenderers.draw(multiTextureRenderTypeRenderer);
            }
        }
        if (this.modMain.getSettings().chunkGrid > -1) {
            int i;
            VertexConsumer lineBufferBuilder = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_LINES);
            int grid = ModSettings.COLORS[this.modMain.getSettings().chunkGrid];
            int r = grid >> 16 & 0xFF;
            int g = grid >> 8 & 0xFF;
            int b = grid & 0xFF;
            MinimapShaders.FRAMEBUFFER_LINES.setFrameSize(this.scalingFramebuffer.f_83917_, this.scalingFramebuffer.f_83918_);
            float red = (float)r / 255.0f;
            float green = (float)g / 255.0f;
            float blue = (float)b / 255.0f;
            float alpha = 0.8f;
            float colorMultiplier = chunkGridAlphaMultiplier;
            red *= colorMultiplier;
            green *= colorMultiplier;
            blue *= colorMultiplier;
            RenderSystem.lineWidth((float)this.modMain.getSettings().chunkGridLineWidth);
            boolean bias = true;
            PoseStack.Pose matrices = matrixStack.m_85850_();
            for (int X = minX; X <= maxX; ++X) {
                drawX = (X - playerChunkX + 1) * 64 - offsetX;
                for (i = 0; i < 4; ++i) {
                    float lineX = (float)drawX + (float)(-16 * i);
                    this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, lineX, -((float)halfMaxVisibleLength), lineX, (float)halfMaxVisibleLength + (float)bias, red, green, blue, alpha);
                }
            }
            for (int Z = minZ; Z <= maxZ; ++Z) {
                int drawZ = (Z - playerChunkZ + 1) * 64 - offsetZ;
                for (i = 0; i < 4; ++i) {
                    float lineZ = (float)drawZ + (float)((double)(-16 * i) - 1.0 / this.zoom);
                    this.helper.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, -((float)halfMaxVisibleLength), lineZ, (float)halfMaxVisibleLength + (float)bias, lineZ, red, green, blue, alpha);
                }
            }
        }
        renderTypeBuffers.m_109911_();
        this.scalingFramebuffer.m_83970_();
        this.rotationFramebuffer.m_83947_(false);
        GL11.glClear((int)16640);
        this.scalingFramebuffer.m_83956_();
        shaderMatrixStack.m_166856_();
        if (this.modMain.getSettings().getAntiAliasing()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        shaderMatrixStack.m_252880_(halfWView, halfWView, -2980.0f);
        shaderMatrixStack.m_85836_();
        if (!lockedNorth) {
            OptimizedMath.rotatePose(shaderMatrixStack, -angle, (Vector3fc)OptimizedMath.ZP);
        }
        shaderMatrixStack.m_85837_(-xInsidePixel * this.zoom, -zInsidePixel * this.zoom, 0.0);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(this.modMain.getSettings().minimapOpacity / 100.0)));
        this.helper.drawMyTexturedModalRect(matrixStack, -256.0f, -256.0f, 0, 0, 512.0f, 512.0f, 512.0f, 512.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        shaderMatrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        before = System.currentTimeMillis();
        CustomRenderTypes.resetTransparency();
        CustomRenderTypes.resetDepthTest();
        CustomRenderTypes.resetWriteMask();
        GL11.glBindTexture((int)3553, (int)0);
        GlStateManager._bindTexture((int)0);
        matrixStack.m_85836_();
        this.minimapElementMapRendererHandler.prepareRender(halfWView);
        this.minimapElementMapRendererHandler.render(guiGraphics, renderEntity, player, renderPos, playerDimDiv, ps, pc, this.zoom, cave, partial, (RenderTarget)this.rotationFramebuffer, multiTextureRenderTypeRenderers);
        matrixStack.m_85849_();
        renderTypeBuffers.m_109911_();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(guiGraphics);
        this.rotationFramebuffer.m_83970_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)projectionMatrixBackup, (VertexSorting)vertexSortingBackup);
        shaderMatrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public void deleteFramebuffers() {
        this.scalingFramebuffer.m_83930_();
        this.rotationFramebuffer.m_83930_();
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public boolean isLoadedFBO() {
        return this.loadedFBO;
    }

    public void setLoadedFBO(boolean loadedFBO) {
        this.loadedFBO = loadedFBO;
    }

    public boolean isTriedFBO() {
        return this.triedFBO;
    }

    public void resetEntityIcons() {
        if (this.entityIconManager != null) {
            this.entityIconManager.reset();
        }
    }

    public void resetEntityIconsResources() {
        if (this.entityIconManager != null) {
            this.entityIconManager.resetResources();
        }
    }

    public void onEntityIconsModelRenderDetection(EntityModel<?> model, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        this.entityIconManager.onModelRenderDetection(model, vertexConsumer, red, green, blue, alpha);
    }

    public void onEntityIconsModelPartRenderDetection(ModelPart modelRenderer, float red, float green, float blue, float alpha) {
        this.entityIconManager.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }

    public void renderMainEntityDot(GuiGraphics guiGraphics, MinimapProcessor minimap, Player p, Entity renderEntity, double ps, double pc, double playerX, double playerZ, float partial, MinimapRadar minimapRadar, boolean lockedNorth, int style, boolean smooth, boolean debug, boolean cave, double dotNameScale, ModSettings settings, MultiBufferSource.BufferSource renderTypeBuffers, float minimapScale) {
        EntityRadarCategory mainEntityCategory = minimapRadar.getEntityCategoryManager().getRuleResolver().resolve(minimapRadar.getEntityCategoryManager().getRootCategory(), renderEntity, p);
        if (mainEntityCategory == null) {
            mainEntityCategory = minimapRadar.getEntityCategoryManager().getRootCategory();
        }
        int dotSize = settings.mainDotSize;
        this.radarRenderer.renderEntityDotToFBO(MinimapElementRenderLocation.OVER_MINIMAP, false, guiGraphics, minimap, p, renderEntity, renderEntity, partial, false, false, minimapRadar, style, smooth, debug, false, cave, dotNameScale, renderTypeBuffers, CustomRenderTypes.GUI_BILINEAR, renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR), null, null, 0, false, 100, false, 100, 1.0, dotSize, mainEntityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue(), 0, mainEntityCategory, this.getHelper(), this.mc.f_91062_, (RenderTarget)this.rotationFramebuffer, minimapScale);
        renderTypeBuffers.m_109911_();
    }

    public RadarRenderer getRadarRenderer() {
        return this.radarRenderer;
    }
}

