/*
 * Decompiled with CFR 0.152.
 */
package de.chrisimo.vegandelight.fluid;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;

public class RecipeFluidType
extends FluidType {
    public static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    public static final ResourceLocation WATER_FLOW = new ResourceLocation("block/water_flow");
    public static final ResourceLocation MILKY_STILL = new ResourceLocation("vegandelight", "block/fluid/milky_still");
    public static final ResourceLocation MILKY_FLOW = new ResourceLocation("vegandelight", "block/fluid/milky_flow");
    public static final ResourceLocation GLOPPY_STILL = new ResourceLocation("vegandelight", "block/fluid/gloppy_still");
    public static final ResourceLocation GLOPPY_FLOW = new ResourceLocation("vegandelight", "block/fluid/gloppy_flow");
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowTexture;
    private int tintColor = -1;

    public static RecipeFluidType createWatery() {
        return new RecipeFluidType(WATER_STILL, WATER_FLOW);
    }

    public static RecipeFluidType createMilky() {
        return new RecipeFluidType(MILKY_STILL, MILKY_FLOW);
    }

    public static RecipeFluidType createGloppy() {
        return new RecipeFluidType(GLOPPY_STILL, GLOPPY_FLOW);
    }

    private RecipeFluidType(ResourceLocation still, ResourceLocation flow) {
        super(FluidType.Properties.create());
        this.stillTexture = still;
        this.flowTexture = flow;
    }

    public RecipeFluidType tint(int tintColor) {
        this.tintColor = tintColor;
        return this;
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return RecipeFluidType.this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return RecipeFluidType.this.flowTexture;
            }

            public int getTintColor() {
                return RecipeFluidType.this.tintColor;
            }
        });
    }
}

