/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final ResourceLocation id;

    protected BlockType(ResourceLocation resourceLocation) {
        this.id = resourceLocation;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.m_135815_();
    }

    public String getNamespace() {
        return this.id.m_135827_();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    protected <V> V findRelatedEntry(String after, Registry<V> reg) {
        return this.findRelatedEntry(after, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String before, String after, Registry<V> reg) {
        if (!((String)after).isEmpty()) {
            after = "_" + (String)after;
        }
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(this.id.m_135827_(), this.id.m_135815_() + "_" + before + (String)after), new ResourceLocation(this.id.m_135827_(), before + "_" + this.id.m_135815_() + (String)after)};
        Object found = null;
        for (ResourceLocation r : targets) {
            if (!reg.m_7804_(r)) continue;
            found = reg.m_7745_(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public Item getItemOfThis(String key) {
        Item item;
        Object v = this.getChild(key);
        if (v instanceof ItemLike) {
            ItemLike i = (ItemLike)v;
            item = i.m_5456_();
        } else {
            item = null;
        }
        return item;
    }

    @Nullable
    public Block getBlockOfThis(String key) {
        Block b;
        Object v = this.getChild(key);
        if (v instanceof BlockItem) {
            BlockItem bi = (BlockItem)v;
            return bi.m_40614_();
        }
        return v instanceof Block ? (b = (Block)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        return this.children.get((Object)key);
    }

    public void addChild(String genericName, @Nullable Object obj) {
        if (obj == Items.f_41852_ || obj == Blocks.f_50016_) {
            throw new IllegalStateException("Tried to add air block/item to Block Type. Key " + genericName + ". This is a Moonlight bug, please report me");
        }
        if (obj != null) {
            try {
                this.children.put((Object)genericName, obj);
                BlockTypeRegistry<?> registry = BlockSetInternal.getRegistry(this.getClass());
                if (registry != null) {
                    registry.mapObjectToType(obj, this);
                }
            }
            catch (Exception e) {
                Moonlight.LOGGER.error("Failed to add block type child: value already present. Key {}, Object {}, BlockType {}", (Object)genericName, obj, (Object)this);
            }
        }
    }

    protected abstract void initializeChildrenBlocks();

    protected abstract void initializeChildrenItems();

    public abstract ItemLike mainChild();

    @Nullable
    public String getChildKey(Object child) {
        return (String)this.children.inverse().get(child);
    }

    @Nullable
    public static Object changeType(Object current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static Item changeItemType(Item current, BlockType originalMat, BlockType destinationMat) {
        Block il;
        Item i;
        BlockItem bi;
        Object blockChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof BlockItem && (blockChanged = BlockType.changeType((bi = (BlockItem)current).m_40614_(), originalMat, destinationMat)) instanceof Block && (i = (il = (Block)blockChanged).m_5456_()) != Items.f_41852_) {
            changed = i;
        }
        if (changed instanceof ItemLike) {
            ItemLike il2 = (ItemLike)changed;
            if (il2.m_5456_() == current) {
                Moonlight.LOGGER.error("Somehow changed an item type into itself. How? Target mat {}, destination map {}, item {}", (Object)destinationMat, (Object)originalMat, (Object)il2);
            }
            return il2.m_5456_();
        }
        return null;
    }

    @Nullable
    public static Block changeBlockType(@NotNull Block current, BlockType originalMat, BlockType destinationMat) {
        BlockItem bi;
        Item i;
        Object itemChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current.m_5456_() != Items.f_41852_ && (itemChanged = BlockType.changeType(current.m_5456_(), originalMat, destinationMat)) instanceof BlockItem && (i = (bi = (BlockItem)itemChanged).m_5456_()) != Items.f_41852_) {
            changed = i;
        }
        if (changed instanceof Block) {
            Block b = (Block)changed;
            return b;
        }
        return null;
    }

    public SoundType getSound() {
        ItemLike itemLike = this.mainChild();
        if (itemLike instanceof Block) {
            Block b = (Block)itemLike;
            return b.m_49962_(b.m_49966_());
        }
        return SoundType.f_56742_;
    }

    @FunctionalInterface
    public static interface SetFinder<T extends BlockType>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

