/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.menus;

import earth.terrarium.chipped.common.blocks.WorkbenchBlock;
import earth.terrarium.chipped.common.recipes.ChippedRecipe;
import earth.terrarium.chipped.common.registry.ModMenuTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkbenchMenu
extends AbstractContainerMenu {
    protected final Inventory inventory;
    protected final Level level;
    protected final RecipeType<ChippedRecipe> recipeType;
    private int selectedStackId;
    private ItemStack selectedStack = ItemStack.f_41583_;
    private ItemStack chosenStack = ItemStack.f_41583_;
    @Nullable
    private String filter;
    private final List<ItemStack> results = new ArrayList<ItemStack>();

    public WorkbenchMenu(int containerId, Inventory inventory, FriendlyByteBuf buf) {
        this(containerId, inventory, WorkbenchMenu.getRecipeFromBuf(inventory.f_35978_.m_9236_(), buf));
    }

    public WorkbenchMenu(int containerId, Inventory inventory, RecipeType<ChippedRecipe> recipeType) {
        super((MenuType)ModMenuTypes.WORKBENCH.get(), containerId);
        this.inventory = inventory;
        this.level = inventory.f_35978_.m_9236_();
        this.recipeType = recipeType;
        this.addPlayerInvSlots();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    protected void addPlayerInvSlots() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new InventorySlot((Container)this.inventory, j + i * 9 + 9, this.getPlayerInvXOffset() + j * 18, this.getPlayerInvYOffset() + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new InventorySlot((Container)this.inventory, i, this.getPlayerInvXOffset() + i * 18, this.getPlayerInvYOffset() + 58));
        }
    }

    public int getPlayerInvXOffset() {
        return 86;
    }

    public int getPlayerInvYOffset() {
        return 167;
    }

    public void m_150399_(int slotId, int button, ClickType clickType, Player player) {
        this.selectStack(slotId);
        super.m_150399_(slotId, button, clickType, player);
    }

    public void selectStack(int slotId) {
        if (slotId < 0 || slotId >= this.f_38839_.size()) {
            return;
        }
        this.selectedStackId = ((Slot)this.f_38839_.get(slotId)).m_150661_();
        this.chosenStack = this.selectedStack = ((Slot)this.f_38839_.get(slotId)).m_7993_();
        this.updateResults(this.filter);
    }

    public void updateResults(@Nullable String filter) {
        if (this.selectedStack.m_41619_()) {
            return;
        }
        this.filter = filter;
        SimpleContainer container = new SimpleContainer(new ItemStack[]{this.selectedStack});
        this.level.m_7465_().m_44015_(this.recipeType, (Container)container, this.level).ifPresentOrElse(recipe -> {
            this.results.clear();
            recipe.getResults(container.m_8020_(0)).forEach(result -> {
                if (filter == null || Util.m_288217_((String)filter) || result.m_41611_().getString().toLowerCase(Locale.ROOT).contains(filter.toLowerCase(Locale.ROOT))) {
                    this.results.add((ItemStack)result);
                }
            });
        }, this::reset);
    }

    public void craft(ItemStack stack, boolean replaceAll) {
        if (stack.m_41619_()) {
            return;
        }
        boolean canCraft = false;
        for (ItemStack result : this.results) {
            if (!ItemStack.m_150942_((ItemStack)result, (ItemStack)stack)) continue;
            canCraft = true;
            break;
        }
        if (!canCraft) {
            return;
        }
        this.inventory.m_6836_(this.selectedStackId, stack.m_255036_(this.inventory.m_8020_(this.selectedStackId).m_41613_()));
        if (replaceAll) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                if (!ItemStack.m_41656_((ItemStack)this.inventory.m_8020_(i), (ItemStack)this.selectedStack)) continue;
                this.inventory.m_6836_(i, stack.m_255036_(this.inventory.m_8020_(i).m_41613_()));
            }
        }
        this.reset();
    }

    public void reset() {
        this.selectedStackId = 0;
        this.selectedStack = ItemStack.f_41583_;
        this.chosenStack = ItemStack.f_41583_;
        this.results.clear();
    }

    public ItemStack selectedStack() {
        return this.selectedStack;
    }

    public ItemStack chosenStack() {
        return this.chosenStack;
    }

    public void setChosenStack(ItemStack stack) {
        this.chosenStack = stack;
    }

    public List<ItemStack> results() {
        return this.results;
    }

    public Level level() {
        return this.level;
    }

    public void setFilter(@Nullable String filter) {
        this.filter = filter;
    }

    protected static RecipeType<ChippedRecipe> getRecipeFromBuf(Level level, FriendlyByteBuf buf) {
        if (buf == null) {
            return null;
        }
        if (!level.f_46443_) {
            return null;
        }
        Block block = level.m_8055_(buf.m_130135_()).m_60734_();
        if (block instanceof WorkbenchBlock) {
            WorkbenchBlock workbench = (WorkbenchBlock)block;
            return workbench.recipeType();
        }
        return null;
    }

    private static class InventorySlot
    extends Slot {
        public InventorySlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_8010_(Player player) {
            return false;
        }
    }
}

