/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import com.delta.redeco.item.ModItems;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GravestoneBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static IntegerProperty SHAPE = IntegerProperty.m_61631_((String)"shape", (int)0, (int)1);
    private static final VoxelShape NORTH_SOUTH_SQUARE = Stream.of(Block.m_49796_((double)1.0, (double)3.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0), Block.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)3.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape EAST_WEST_SQUARE = Stream.of(Block.m_49796_((double)6.0, (double)3.0, (double)1.0, (double)10.0, (double)16.0, (double)15.0), Block.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)3.0, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape NORTH_SOUTH_CROSS = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)4.0, (double)13.0, (double)2.0, (double)12.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)2.0, (double)9.0, (double)6.0, (double)14.0, (double)13.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape EAST_WEST_CROSS = Stream.of(Block.m_49796_((double)4.0, (double)0.0, (double)3.0, (double)12.0, (double)2.0, (double)13.0), Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), Block.m_49796_((double)6.0, (double)9.0, (double)2.0, (double)10.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public GravestoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if ((Integer)pState.m_61143_((Property)SHAPE) == 0) {
            switch ((Direction)pState.m_61143_((Property)FACING)) {
                case NORTH: 
                case SOUTH: {
                    return NORTH_SOUTH_SQUARE;
                }
                case EAST: 
                case WEST: {
                    return EAST_WEST_SQUARE;
                }
            }
        }
        if ((Integer)pState.m_61143_((Property)SHAPE) == 1) {
            switch ((Direction)pState.m_61143_((Property)FACING)) {
                case NORTH: 
                case SOUTH: {
                    return NORTH_SOUTH_CROSS;
                }
                case EAST: 
                case WEST: {
                    return EAST_WEST_CROSS;
                }
            }
        }
        return NORTH_SOUTH_SQUARE;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        Random rand = new Random();
        int rand_type = rand.nextInt(2);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)SHAPE, (Comparable)Integer.valueOf(rand_type))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_150930_((Item)ModItems.HAMMER.get())) {
            if ((Integer)state.m_61143_((Property)SHAPE) == 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SHAPE, (Comparable)Integer.valueOf(1)), 2);
                level.m_5594_(null, pos, SoundEvents.f_12442_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if ((Integer)state.m_61143_((Property)SHAPE) == 1) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)SHAPE, (Comparable)Integer.valueOf(0)), 2);
                level.m_5594_(null, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

