/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampBlock
extends EndRodBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    private static final VoxelShape STANDING = Stream.of(Block.m_49796_((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)6.0, (double)9.0), Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape HANGING = Stream.of(Block.m_49796_((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), Block.m_49796_((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), Block.m_49796_((double)5.0, (double)14.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape WALL_NORTH = Stream.of(Block.m_49796_((double)3.0, (double)6.0, (double)5.0, (double)13.0, (double)14.0, (double)15.0), Block.m_49796_((double)7.0, (double)3.0, (double)9.0, (double)9.0, (double)6.0, (double)11.0), Block.m_49796_((double)7.0, (double)3.0, (double)11.0, (double)9.0, (double)5.0, (double)14.0), Block.m_49796_((double)5.0, (double)1.0, (double)14.0, (double)11.0, (double)7.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape WALL_SOUTH = Stream.of(Block.m_49796_((double)3.0, (double)6.0, (double)1.0, (double)13.0, (double)14.0, (double)11.0), Block.m_49796_((double)7.0, (double)3.0, (double)5.0, (double)9.0, (double)6.0, (double)7.0), Block.m_49796_((double)7.0, (double)3.0, (double)2.0, (double)9.0, (double)5.0, (double)5.0), Block.m_49796_((double)5.0, (double)1.0, (double)0.0, (double)11.0, (double)7.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape WALL_EAST = Stream.of(Block.m_49796_((double)1.0, (double)6.0, (double)3.0, (double)11.0, (double)14.0, (double)13.0), Block.m_49796_((double)5.0, (double)3.0, (double)7.0, (double)7.0, (double)6.0, (double)9.0), Block.m_49796_((double)2.0, (double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)9.0), Block.m_49796_((double)0.0, (double)1.0, (double)5.0, (double)2.0, (double)7.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape WALL_WEST = Stream.of(Block.m_49796_((double)5.0, (double)6.0, (double)3.0, (double)15.0, (double)14.0, (double)13.0), Block.m_49796_((double)9.0, (double)3.0, (double)7.0, (double)11.0, (double)6.0, (double)9.0), Block.m_49796_((double)11.0, (double)3.0, (double)7.0, (double)14.0, (double)5.0, (double)9.0), Block.m_49796_((double)14.0, (double)1.0, (double)5.0, (double)16.0, (double)7.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape BASE = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape POST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SHADE = Block.m_49796_((double)2.0, (double)1.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public LampBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        boolean up = (Boolean)pState.m_61143_((Property)UP);
        boolean down = (Boolean)pState.m_61143_((Property)DOWN);
        switch ((Direction)pState.m_61143_((Property)f_52588_)) {
            case NORTH: {
                return WALL_NORTH;
            }
            case SOUTH: {
                return WALL_SOUTH;
            }
            case EAST: {
                return WALL_EAST;
            }
            case WEST: {
                return WALL_WEST;
            }
            case UP: {
                if (((Boolean)pState.m_61143_((Property)UP)).booleanValue() && !((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                    return BASE;
                }
                if (((Boolean)pState.m_61143_((Property)UP)).booleanValue() && ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                    return POST;
                }
                if (!((Boolean)pState.m_61143_((Property)UP)).booleanValue() && ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                    return SHADE;
                }
                return STANDING;
            }
            case DOWN: {
                if (((Boolean)pState.m_61143_((Property)UP)).booleanValue() && !((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                    return BASE;
                }
                if (((Boolean)pState.m_61143_((Property)UP)).booleanValue() && ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                    return POST;
                }
                if (!((Boolean)pState.m_61143_((Property)UP)).booleanValue() && ((Boolean)pState.m_61143_((Property)DOWN)).booleanValue()) {
                    return SHADE;
                }
                return HANGING;
            }
        }
        return STANDING;
    }

    private boolean isLamp(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        return state.m_60734_() == this;
    }

    private boolean isOnWall(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                return true;
            }
        }
        return false;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean up = this.isLamp(level, pos, Direction.UP);
        boolean down = this.isLamp(level, pos, Direction.DOWN);
        if (this.isLamp(level, pos, Direction.UP) && this.isOnWall(level, pos, Direction.UP)) {
            up = false;
        }
        if (this.isLamp(level, pos, Direction.DOWN) && this.isOnWall(level, pos, Direction.DOWN)) {
            down = false;
        }
        return super.m_7417_((BlockState)((BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(up))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(down)), direction, state, level, pos, newPos);
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRand) {
        boolean THING = true;
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction direction = pContext.m_43719_();
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(direction.m_122424_()));
        FluidState fluidState = pContext.m_43725_().m_6425_(pContext.m_8083_());
        return blockstate.m_60713_((Block)this) && blockstate.m_61143_((Property)f_52588_) == direction ? (BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction.m_122424_()) : (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, UP, DOWN});
    }
}

