/*
 * Decompiled with CFR 0.152.
 */
package com.delta.redeco.block.custom;

import com.delta.redeco.block.entity.ModBlockEntities;
import com.delta.redeco.block.entity.custom.ShelfBlockEntity;
import com.delta.redeco.item.ModItems;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty ROTATING = BooleanProperty.m_61465_((String)"rotating");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)0.0, (double)5.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)8.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape SHAPE_CORNER_NE = Stream.of(Block.m_49796_((double)8.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_CORNER_NW = Stream.of(Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_CORNER_SE = Stream.of(Block.m_49796_((double)8.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_CORNER_SW = Stream.of(Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        boolean north = (Boolean)pState.m_61143_((Property)NORTH);
        boolean south = (Boolean)pState.m_61143_((Property)SOUTH);
        boolean east = (Boolean)pState.m_61143_((Property)EAST);
        boolean west = (Boolean)pState.m_61143_((Property)WEST);
        VoxelShape SHAPE = SHAPE_NORTH;
        if (facing == Direction.NORTH) {
            SHAPE = SHAPE_NORTH;
            if (north && east) {
                SHAPE = SHAPE_CORNER_NW;
            }
            if (north && west) {
                SHAPE = SHAPE_CORNER_NE;
            }
        }
        if (facing == Direction.SOUTH) {
            SHAPE = SHAPE_SOUTH;
            if (south && east) {
                SHAPE = SHAPE_CORNER_SW;
            }
            if (south && west) {
                SHAPE = SHAPE_CORNER_SE;
            }
        }
        if (facing == Direction.EAST) {
            SHAPE = SHAPE_EAST;
            if (east && north) {
                SHAPE = SHAPE_CORNER_NW;
            }
            if (south && east) {
                SHAPE = SHAPE_CORNER_SW;
            }
        }
        if (facing == Direction.WEST) {
            SHAPE = SHAPE_WEST;
            if (north && west) {
                SHAPE = SHAPE_CORNER_NE;
            }
            if (south && west) {
                SHAPE = SHAPE_CORNER_SE;
            }
        }
        return SHAPE;
    }

    private boolean isShelf(LevelAccessor level, BlockPos source, Direction direction) {
        BlockState state = level.m_8055_(source.m_121945_(direction));
        return state.m_60734_() == this;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)level.m_7702_(pos));
    }

    private boolean canAttachTo(BlockGetter pBlockReader, BlockPos pPos, Direction pDirection) {
        BlockState blockstate = pBlockReader.m_8055_(pPos);
        return blockstate.m_60783_(pBlockReader, pPos, pDirection);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        return this.canAttachTo((BlockGetter)pLevel, pPos.m_121945_(direction.m_122424_()), direction);
    }

    public BlockState m_7417_(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        boolean north = this.isShelf(pLevel, pCurrentPos, Direction.NORTH);
        boolean east = this.isShelf(pLevel, pCurrentPos, Direction.EAST);
        boolean south = this.isShelf(pLevel, pCurrentPos, Direction.SOUTH);
        boolean west = this.isShelf(pLevel, pCurrentPos, Direction.WEST);
        if (pFacing.m_122424_() == pState.m_61143_((Property)FACING) && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_((BlockState)((BlockState)((BlockState)((BlockState)pState.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(north))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(east))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(south))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(west)), pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate;
        if (!pContext.m_7058_() && (blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_121945_(pContext.m_43719_().m_122424_()))).m_60713_((Block)this) && blockstate.m_61143_((Property)FACING) == pContext.m_43719_()) {
            return null;
        }
        BlockState blockstate1 = this.m_49966_();
        Level levelreader = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        for (Direction direction : pContext.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(blockstate1 = (BlockState)blockstate1.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)levelreader, blockpos)) continue;
            return (BlockState)blockstate1.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, WATERLOGGED, NORTH, SOUTH, EAST, WEST, ROTATING});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity tileEntity = level.m_7702_(pos);
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack offhandStack = player.m_21206_();
        if (heldStack.m_150930_((Item)ModItems.HAMMER.get())) {
            if (((Boolean)state.m_61143_((Property)ROTATING)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ROTATING, (Comparable)Boolean.valueOf(false)), 2);
            }
            if (!((Boolean)state.m_61143_((Property)ROTATING)).booleanValue()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)ROTATING, (Comparable)Boolean.valueOf(true)), 2);
            }
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
            if (!level.f_46443_) {
                heldStack.m_41622_(1, (LivingEntity)player, playerIn -> playerIn.m_21190_(hand));
            }
            return InteractionResult.SUCCESS;
        }
        if (tileEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity ShelfEntity = (ShelfBlockEntity)tileEntity;
            if (ShelfEntity.isEmpty()) {
                if (heldStack.m_41619_()) {
                    return InteractionResult.PASS;
                }
                if (ShelfEntity.addItem(player.m_150110_().f_35937_ ? heldStack.m_41777_() : heldStack)) {
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!heldStack.m_41619_()) {
                    return InteractionResult.CONSUME;
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    if (!player.m_7500_()) {
                        if (!player.m_150109_().m_36054_(ShelfEntity.removeItem())) {
                            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)ShelfEntity.removeItem());
                        }
                    } else {
                        ShelfEntity.removeItem();
                    }
                    level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12634_, SoundSource.BLOCKS, 0.25f, 0.5f);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof ShelfBlockEntity) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)((ShelfBlockEntity)tileEntity).getStoredItem());
                level.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)ModBlockEntities.SHELF_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }
}

