/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import fuzs.puzzleslib.api.biome.v1.BiomeLoadingPhase;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.core.v1.ModContainerHelper;
import fuzs.puzzleslib.api.item.v2.LegacySmithingTransformRecipe;
import fuzs.puzzleslib.impl.core.BiomeLoadingHandler;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.BiomeModificationsContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.BlockInteractionsContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.BuildCreativeModeTabContentsContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.CreativeModeTabContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.DataPackSourcesContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.EntityAttributesCreateContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.EntityAttributesModifyContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.FlammableBlocksContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.FuelBurnTimesContextForgeImpl;
import fuzs.puzzleslib.impl.core.context.SpawnPlacementsContextForgeImpl;
import fuzs.puzzleslib.impl.item.CopyTagRecipe;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public final class ForgeModConstructor {
    private ForgeModConstructor() {
    }

    public static void construct(ModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        ModContainerHelper.getOptionalModEventBus(modId).ifPresent(modEventBus -> {
            HashMultimap biomeModifications = HashMultimap.create();
            ForgeModConstructor.registerContent(constructor, modId, modEventBus, (Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification>)biomeModifications, flagsToHandle);
            ForgeModConstructor.registerModHandlers(constructor, modId, modEventBus, (Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification>)biomeModifications, availableFlags, flagsToHandle);
            ForgeModConstructor.registerHandlers(constructor, modId);
            constructor.onConstructMod();
        });
    }

    private static void registerContent(ModConstructor constructor, String modId, IEventBus modEventBus, Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification> biomeModifications, Set<ContentRegistrationFlags> flagsToHandle) {
        constructor.onRegisterCreativeModeTabs(new CreativeModeTabContextForgeImpl(modEventBus));
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS)) {
            BiomeLoadingHandler.register(modId, modEventBus, biomeModifications);
        }
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.LEGACY_SMITHING) || flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_TAG_RECIPES)) {
            DeferredRegister deferredRegister = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.RECIPE_SERIALIZERS, (String)modId);
            deferredRegister.register(modEventBus);
            if (flagsToHandle.contains((Object)ContentRegistrationFlags.LEGACY_SMITHING)) {
                deferredRegister.register("legacy_smithing_transform", LegacySmithingTransformRecipe.Serializer::new);
            }
            if (flagsToHandle.contains((Object)ContentRegistrationFlags.COPY_TAG_RECIPES)) {
                CopyTagRecipe.registerSerializers((arg_0, arg_1) -> ((DeferredRegister)deferredRegister).register(arg_0, arg_1));
            }
        }
    }

    private static void registerModHandlers(ModConstructor constructor, String modId, IEventBus eventBus, Multimap<BiomeLoadingPhase, BiomeLoadingHandler.BiomeModification> biomeModifications, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        eventBus.addListener(evt -> evt.enqueueWork(() -> {
            constructor.onCommonSetup();
            constructor.onRegisterFuelBurnTimes(new FuelBurnTimesContextForgeImpl());
            constructor.onRegisterBiomeModifications(new BiomeModificationsContextForgeImpl(biomeModifications, availableFlags));
            constructor.onRegisterFlammableBlocks(new FlammableBlocksContextForgeImpl());
            constructor.onRegisterBlockInteractions(new BlockInteractionsContextForgeImpl());
        }));
        eventBus.addListener(evt -> constructor.onRegisterSpawnPlacements(new SpawnPlacementsContextForgeImpl((SpawnPlacementRegisterEvent)evt)));
        eventBus.addListener(evt -> constructor.onEntityAttributeCreation(new EntityAttributesCreateContextForgeImpl((arg_0, arg_1) -> ((EntityAttributeCreationEvent)evt).put(arg_0, arg_1))));
        eventBus.addListener(evt -> constructor.onEntityAttributeModification(new EntityAttributesModifyContextForgeImpl((arg_0, arg_1, arg_2) -> ((EntityAttributeModificationEvent)evt).add(arg_0, arg_1, arg_2))));
        eventBus.addListener(evt -> constructor.onBuildCreativeModeTabContents(new BuildCreativeModeTabContentsContextForgeImpl((ResourceKey<CreativeModeTab>)evt.getTabKey(), evt.getParameters(), (CreativeModeTab.Output)evt)));
        eventBus.addListener(evt -> {
            if (evt.getPackType() == PackType.SERVER_DATA) {
                constructor.onAddDataPackFinders(new DataPackSourcesContextForgeImpl(arg_0 -> ((AddPackFindersEvent)evt).addRepositorySource(arg_0)));
                if (flagsToHandle.contains((Object)ContentRegistrationFlags.BIOME_MODIFICATIONS)) {
                    evt.addRepositorySource(BiomeLoadingHandler.buildPack(modId));
                }
            }
        });
    }

    private static void registerHandlers(ModConstructor constructor, String modId) {
        MinecraftForge.EVENT_BUS.addListener(evt -> constructor.onRegisterDataPackReloadListeners(new AddReloadListenersContextForgeImpl(modId, arg_0 -> ((AddReloadListenerEvent)evt).addListener(arg_0))));
    }
}

