/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.renderer;

import com.direwolf20.buildinggadgets2.common.blocks.RenderBlock;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.minecraftforge.fluids.FluidStack;

public class RenderFluidBlock {
    private static BakedQuad createQuad(List<Vec3> vectors, float[] cols, TextureAtlasSprite sprite, Direction face, float u1, float u2, float v1, float v2) {
        QuadBakingVertexConsumer.Buffered quadBaker = new QuadBakingVertexConsumer.Buffered();
        Vec3 normal = Vec3.m_82528_((Vec3i)face.m_122436_());
        RenderFluidBlock.putVertex((QuadBakingVertexConsumer)quadBaker, normal, vectors.get((int)0).f_82479_, vectors.get((int)0).f_82480_, vectors.get((int)0).f_82481_, u1, v1, sprite, cols, face);
        RenderFluidBlock.putVertex((QuadBakingVertexConsumer)quadBaker, normal, vectors.get((int)1).f_82479_, vectors.get((int)1).f_82480_, vectors.get((int)1).f_82481_, u1, v2, sprite, cols, face);
        RenderFluidBlock.putVertex((QuadBakingVertexConsumer)quadBaker, normal, vectors.get((int)2).f_82479_, vectors.get((int)2).f_82480_, vectors.get((int)2).f_82481_, u2, v2, sprite, cols, face);
        RenderFluidBlock.putVertex((QuadBakingVertexConsumer)quadBaker, normal, vectors.get((int)3).f_82479_, vectors.get((int)3).f_82480_, vectors.get((int)3).f_82481_, u2, v1, sprite, cols, face);
        return quadBaker.getQuad();
    }

    private static void putVertex(QuadBakingVertexConsumer quadBaker, Vec3 normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float[] cols, Direction face) {
        quadBaker.m_5483_(x, y, z);
        quadBaker.m_5601_((float)normal.f_82479_, (float)normal.f_82480_, (float)normal.f_82481_);
        quadBaker.m_85950_(cols[0], cols[1], cols[2], cols[3]);
        quadBaker.m_7421_(sprite.m_118367_((double)u), sprite.m_118393_((double)v));
        quadBaker.setSprite(sprite);
        quadBaker.setDirection(face);
        quadBaker.m_5752_();
    }

    public static void renderFluidBlock(BlockState renderState, Level level, BlockPos pos, PoseStack matrixStackIn, VertexConsumer builder, boolean renderAdjacent) {
        BakedQuad quad;
        if (renderState.m_60819_().m_76178_()) {
            return;
        }
        FluidState fluidState = renderState.m_60819_();
        Fluid fluid = fluidState.m_76152_();
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(extensions.getStillTexture(fluidStack));
        int color = extensions.getTintColor(fluidStack);
        int brightness = LevelRenderer.m_109541_((BlockAndTintGetter)level, (BlockPos)pos);
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float minU = sprite.m_118409_();
        float minV = sprite.m_118411_();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        float x2 = 1.0f;
        float z2 = 1.0f;
        float height = 0.875f;
        float size = 16.0f;
        float[] cols = new float[]{r, g, b, a};
        matrixStackIn.m_85836_();
        if (renderAdjacent || !(level.m_8055_(pos.m_121945_(Direction.DOWN)).m_60734_() instanceof RenderBlock)) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)y, (double)z2), (Object)new Vec3((double)x, (double)y, (double)z), (Object)new Vec3((double)x2, (double)y, (double)z), (Object)new Vec3((double)x2, (double)y, (double)z2)), cols, sprite, Direction.DOWN, minU, size, minV, size);
            builder.putBulkData(matrixStackIn.m_85850_(), quad, r, g, b, a, brightness, 0, false);
        }
        if (renderAdjacent || !(level.m_8055_(pos.m_121945_(Direction.UP)).m_60734_() instanceof RenderBlock)) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z), (Object)new Vec3((double)x, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z)), cols, sprite, Direction.UP, minU, size, minV, size);
            builder.putBulkData(matrixStackIn.m_85850_(), quad, r, g, b, a, brightness, 0, false);
        }
        if (renderAdjacent || !(level.m_8055_(pos.m_121945_(Direction.NORTH)).m_60734_() instanceof RenderBlock)) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x2, (double)height, (double)z), (Object)new Vec3((double)x2, (double)y, (double)z), (Object)new Vec3((double)x, (double)y, (double)z), (Object)new Vec3((double)x, (double)height, (double)z)), cols, sprite, Direction.NORTH, minU, size, minV, size);
            builder.putBulkData(matrixStackIn.m_85850_(), quad, r, g, b, a, brightness, 0, false);
        }
        if (renderAdjacent || !(level.m_8055_(pos.m_121945_(Direction.SOUTH)).m_60734_() instanceof RenderBlock)) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z2), (Object)new Vec3((double)x, (double)y, (double)z2), (Object)new Vec3((double)x2, (double)y, (double)z2), (Object)new Vec3((double)x2, (double)height, (double)z2)), cols, sprite, Direction.SOUTH, minU, size, minV, size);
            builder.putBulkData(matrixStackIn.m_85850_(), quad, r, g, b, a, brightness, 0, false);
        }
        if (renderAdjacent || !(level.m_8055_(pos.m_121945_(Direction.WEST)).m_60734_() instanceof RenderBlock)) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x, (double)height, (double)z), (Object)new Vec3((double)x, (double)y, (double)z), (Object)new Vec3((double)x, (double)y, (double)z2), (Object)new Vec3((double)x, (double)height, (double)z2)), cols, sprite, Direction.WEST, minU, size, minV, size);
            builder.putBulkData(matrixStackIn.m_85850_(), quad, r, g, b, a, brightness, 0, false);
        }
        if (renderAdjacent || !(level.m_8055_(pos.m_121945_(Direction.EAST)).m_60734_() instanceof RenderBlock)) {
            quad = RenderFluidBlock.createQuad((List<Vec3>)ImmutableList.of((Object)new Vec3((double)x2, (double)height, (double)z2), (Object)new Vec3((double)x2, (double)y, (double)z2), (Object)new Vec3((double)x2, (double)y, (double)z), (Object)new Vec3((double)x2, (double)height, (double)z)), cols, sprite, Direction.EAST, minU, size, minV, size);
            builder.putBulkData(matrixStackIn.m_85850_(), quad, r, g, b, a, brightness, 0, false);
        }
        matrixStackIn.m_85849_();
    }
}

