/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.commands;

import com.direwolf20.buildinggadgets2.common.network.PacketHandler;
import com.direwolf20.buildinggadgets2.common.network.packets.PacketSendCopyData;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Registration;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.MiscHelpers;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import com.google.common.collect.BiMap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RedprintCommand {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(p_214470_ -> p_214470_.m_6761_(0))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list").requires(p_214470_ -> p_214470_.m_6761_(0))).executes(p_258233_ -> RedprintCommand.listRedprints((CommandSourceStack)p_258233_.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(p_214470_ -> p_214470_.m_6761_(3))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(p_258232_ -> RedprintCommand.removeRedprint((CommandSourceStack)p_258232_.getSource(), StringArgumentType.getString((CommandContext)p_258232_, (String)"name")))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(p_214470_ -> p_214470_.m_6761_(3))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91466_()).executes(p_258232_ -> RedprintCommand.giveRedprint((CommandSourceStack)p_258232_.getSource(), StringArgumentType.getString((CommandContext)p_258232_, (String)"name"), EntityArgument.m_91474_((CommandContext)p_258232_, (String)"targets"))))));
    }

    private static int listRedprints(CommandSourceStack pSource) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(pSource.m_230896_().m_9236_().m_7654_()).m_129783_());
        BiMap<UUID, String> redmaps = bg2Data.getRedprintLookup();
        for (Map.Entry entry : redmaps.entrySet()) {
            pSource.m_288197_(() -> Component.m_237113_((String)((String)entry.getValue())), false);
        }
        return redmaps.size();
    }

    private static int removeRedprint(CommandSourceStack pSource, String name) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(pSource.m_230896_().m_9236_().m_7654_()).m_129783_());
        if (bg2Data.removeFromRedprints(name)) {
            pSource.m_288197_(() -> Component.m_237110_((String)"buildinggadgets2.messages.redprintremovesuccess", (Object[])new Object[]{name}), false);
        } else {
            pSource.m_288197_(() -> Component.m_237110_((String)"buildinggadgets2.messages.redprintremovefail", (Object[])new Object[]{name}), false);
        }
        return 1;
    }

    private static int giveRedprint(CommandSourceStack pSource, String name, ServerPlayer serverPlayer) {
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(pSource.m_230896_().m_9236_().m_7654_()).m_129783_());
        UUID sourceUUID = bg2Data.getRedprintUUIDfromName(name);
        if (sourceUUID == null) {
            pSource.m_288197_(() -> Component.m_237110_((String)"buildinggadgets2.messages.redprintgivefail", (Object[])new Object[]{name, serverPlayer.m_5446_()}), false);
            MiscHelpers.playSound(serverPlayer, (Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(SoundEvents.f_276627_.m_11660_().toString()))));
            return 0;
        }
        ItemStack newRedprint = new ItemStack((ItemLike)Registration.Redprint.get());
        UUID targetUUID = GadgetNBT.getUUID(newRedprint);
        ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(sourceUUID, false);
        GadgetNBT.setCopyUUID(newRedprint);
        bg2Data.addToCopyPaste(targetUUID, buildList);
        ArrayList<TagPos> teMap = bg2Data.peekTEMap(sourceUUID);
        ArrayList<TagPos> copiedMap = new ArrayList<TagPos>(Objects.requireNonNullElseGet(teMap, ArrayList::new));
        bg2Data.addToTEMap(targetUUID, copiedMap);
        GadgetNBT.setTemplateName(newRedprint, name);
        CompoundTag tag = bg2Data.getCopyPasteListAsNBTMap(targetUUID, false);
        PacketHandler.sendTo(new PacketSendCopyData(targetUUID, GadgetNBT.getCopyUUID(newRedprint), tag), serverPlayer);
        serverPlayer.m_36356_(newRedprint);
        MiscHelpers.playSound(serverPlayer, (Holder<SoundEvent>)Holder.m_205709_((Object)SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(SoundEvents.f_11887_.m_11660_().toString()))));
        return 1;
    }
}

