/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketRangeChange {
    int range;

    public PacketRangeChange(int range) {
        this.range = range;
    }

    public static PacketRangeChange decode(FriendlyByteBuf buf) {
        return new PacketRangeChange(buf.readInt());
    }

    public static void encode(PacketRangeChange message, FriendlyByteBuf buf) {
        buf.writeInt(message.range);
    }

    public static void handle(PacketRangeChange message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            ItemStack gadget = BaseGadget.getGadget((Player)sender);
            if (gadget.m_41619_() || !(gadget.m_41720_() instanceof GadgetBuilding) && !(gadget.m_41720_() instanceof GadgetExchanger)) {
                return;
            }
            GadgetNBT.setToolRange(gadget, message.range);
            sender.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.range_set", (Object[])new Object[]{message.range}), true);
        });
        context.get().setPacketHandled(true);
    }
}

