/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketRenderChange {
    byte renderType;

    public PacketRenderChange(byte renderType) {
        this.renderType = renderType;
    }

    public static PacketRenderChange decode(FriendlyByteBuf buf) {
        return new PacketRenderChange(buf.readByte());
    }

    public static void encode(PacketRenderChange message, FriendlyByteBuf buf) {
        buf.writeByte((int)message.renderType);
    }

    public static void handle(PacketRenderChange message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            ItemStack gadget = BaseGadget.getGadget((Player)sender);
            if (gadget.m_41619_()) {
                return;
            }
            GadgetNBT.setRenderType(gadget, message.renderType);
            sender.m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.render_set", (Object[])new Object[]{Component.m_237115_((String)GadgetNBT.getRenderType(gadget).getLang())}), true);
        });
        context.get().setPacketHandled(true);
    }
}

