/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.VectorHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class UseContext {
    private final Level world;
    private final BlockState setState;
    private final BlockPos startPos;
    private final Direction hitSide;
    private final Player player;
    private final boolean isFuzzy;
    private final boolean placeOnTop;
    private final int range;
    private final boolean rayTraceFluid;
    private final boolean isConnected;

    public UseContext(Level world, Player player, BlockState setState, BlockPos startPos, ItemStack gadget, Direction hitSide, boolean placeOnTop, boolean isConnected) {
        this.world = world;
        this.setState = setState;
        this.startPos = startPos;
        this.player = player;
        this.range = GadgetNBT.getToolRange(gadget);
        this.isFuzzy = GadgetNBT.getFuzzy(gadget);
        this.rayTraceFluid = GadgetNBT.shouldRayTraceFluid(gadget);
        this.hitSide = hitSide;
        this.isConnected = isConnected;
        this.placeOnTop = placeOnTop;
    }

    public UseContext(Level world, Player player, BlockState setState, BlockPos startPos, ItemStack gadget, Direction hitSide, boolean isConnected) {
        this(world, player, setState, startPos, gadget, hitSide, false, isConnected);
    }

    public BlockPlaceContext createBlockUseContext() {
        return new BlockPlaceContext(new UseOnContext(this.player, InteractionHand.MAIN_HAND, VectorHelper.getLookingAt(this.player, this.rayTraceFluid)));
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public BlockState getWorldState(BlockPos pos) {
        return this.world.m_8055_(pos);
    }

    public Level getWorld() {
        return this.world;
    }

    public BlockState getSetState() {
        return this.setState;
    }

    public boolean isFuzzy() {
        return this.isFuzzy;
    }

    public boolean isRayTraceFluid() {
        return this.rayTraceFluid;
    }

    public boolean isPlaceOnTop() {
        return this.placeOnTop;
    }

    public int getRange() {
        return this.range;
    }

    public BlockPos getStartPos() {
        return this.startPos;
    }

    public Direction getHitSide() {
        return this.hitSide;
    }

    public Player getPlayer() {
        return this.player;
    }

    public String toString() {
        return "UseContext{world=" + this.world + ", setState=" + this.setState + ", startPos=" + this.startPos + ", hitSide=" + this.hitSide + ", isFuzzy=" + this.isFuzzy + ", placeOnTop=" + this.placeOnTop + ", range=" + this.range + ", rayTraceFluid=" + this.rayTraceFluid + "}";
    }
}

