/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.kinetics.fan.processing;

import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingTypeRegistry;
import com.simibubi.create.foundation.recipe.RecipeApplier;
import com.simibubi.create.foundation.utility.Color;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.davio.aquaticambitions.CreateAquaticAmbitions;
import net.davio.aquaticambitions.entry.CCARecipeTypes;
import net.davio.aquaticambitions.entry.CCATags;
import net.davio.aquaticambitions.kinetics.fan.processing.ChannelingRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class CCAFanProcessingTypes {
    public static final ChannelingType CHANNELING = CCAFanProcessingTypes.register("channeling", new ChannelingType());

    private static <T extends FanProcessingType> T register(String id, T type) {
        FanProcessingTypeRegistry.register((ResourceLocation)CreateAquaticAmbitions.asResource(id), type);
        return type;
    }

    public static void register() {
    }

    static {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)"CHANNELING", (Object)CHANNELING);
        map.trim();
    }

    public static class ChannelingType
    implements FanProcessingType {
        private static final ChannelingRecipe.ChannelingWrapper CHANNELING_WRAPPER = new ChannelingRecipe.ChannelingWrapper();

        public boolean isValidAt(Level level, BlockPos pos) {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        BlockPos adjacentPos = pos.m_7918_(i, j, k);
                        BlockEntity blockEntity = level.m_7702_(adjacentPos);
                        if (!(blockEntity instanceof ConduitBlockEntity) || !((ConduitBlockEntity)blockEntity).m_59216_()) continue;
                        return true;
                    }
                }
            }
            FluidState fluidState = level.m_6425_(pos);
            BlockState blockState = level.m_8055_(pos);
            return blockState.m_204336_(CCATags.FAN_CHANNELING_PROCESSING_TAG) && fluidState.m_205070_(CCATags.FAN_CHANNELING_PROCESSING_FLUID_TAG);
        }

        public int getPriority() {
            return 1200;
        }

        public boolean canProcess(ItemStack stack, Level level) {
            CHANNELING_WRAPPER.m_6836_(0, stack);
            Optional recipe = CCARecipeTypes.CHANNELING.find(CHANNELING_WRAPPER, level);
            return recipe.isPresent();
        }

        @Nullable
        public List<ItemStack> process(ItemStack stack, Level level) {
            CHANNELING_WRAPPER.m_6836_(0, stack);
            Optional<ChannelingRecipe> recipe = CCARecipeTypes.CHANNELING.find(CHANNELING_WRAPPER, level);
            return recipe.map(channelingRecipe -> RecipeApplier.applyRecipeOn((Level)level, (ItemStack)stack, (Recipe)channelingRecipe)).orElse(null);
        }

        public void spawnProcessingParticles(Level level, Vec3 pos) {
            if (level.f_46441_.m_188503_(8) != 0) {
                return;
            }
            Vector3f color = new Color(22015).asVectorF();
            level.m_7106_((ParticleOptions)new DustParticleOptions(color, 1.0f), pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), 0.0, 0.125, 0.0);
            if (level.f_46441_.m_188503_(8) < 2) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123775_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f));
            } else if (level.f_46441_.m_188503_(8) < 4) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), pos.f_82480_ + 0.5, pos.f_82481_ + (double)((level.f_46441_.m_188501_() - 0.5f) * 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f), (double)(level.f_46441_.m_188501_() - 0.5f));
            }
        }

        public void morphAirFlow(FanProcessingType.AirFlowParticleAccess particleAccess, RandomSource random) {
            particleAccess.setColor(Color.mixColors((int)2070193, (int)22015, (float)random.m_188501_()));
            particleAccess.setAlpha(1.0f);
            if (random.m_188501_() < 0.00390625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123809_, 0.125f);
            }
            if (random.m_188501_() < 9.765625E-4f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123775_, 0.075f);
            }
            if (random.m_188501_() < 0.015625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123795_, 0.125f);
            }
            if (random.m_188501_() < 0.015625f) {
                particleAccess.spawnExtraParticle((ParticleOptions)ParticleTypes.f_123772_, 0.125f);
            }
        }

        public void affectEntity(Entity entity, Level level) {
            if (level.f_46443_) {
                return;
            }
            if (entity instanceof Player) {
                ((Player)entity).m_7292_(new MobEffectInstance(MobEffects.f_19592_, 260, 0, true, true));
            }
        }
    }
}

