/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.base.util;

import com.rabbitminers.extendedgears.base.util.forge.EnvImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public enum Env {
    CLIENT,
    SERVER;

    public static final Env CURRENT;

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public static <T> T unsafeRunForDist(Supplier<Supplier<T>> clientTarget, Supplier<Supplier<T>> serverTarget) {
        return switch (CURRENT) {
            default -> throw new IncompatibleClassChangeError();
            case CLIENT -> clientTarget.get().get();
            case SERVER -> serverTarget.get().get();
        };
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Env getCurrent() {
        return EnvImpl.getCurrent();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isForge() {
        return EnvImpl.isForge();
    }

    static {
        CURRENT = Env.getCurrent();
    }
}

