/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.cogwheels.materials;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class CogwheelMaterial
implements Predicate<ItemStack> {
    public final ResourceLocation id;
    public static int MAX_STRESS = Integer.MAX_VALUE;
    public final Map<ResourceLocation, ResourceLocation> textures;
    public final boolean chunky;
    public NonNullList<Ingredient> items = NonNullList.m_122779_();
    public int stressLimit = MAX_STRESS;
    public int speedLimit = 256;

    public CogwheelMaterial(ResourceLocation id, Map<ResourceLocation, ResourceLocation> textures, boolean chunky) {
        this.id = id;
        this.textures = textures;
        this.chunky = chunky;
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.items.stream().anyMatch(ingredient -> ingredient.test(itemStack));
    }

    public void updateFromJson(JsonObject object) {
        try {
            JsonElement ingredients = object.get("items");
            if (ingredients != null && ingredients.isJsonArray()) {
                NonNullList<Ingredient> items = CogwheelMaterial.ingredientsFromJson(ingredients.getAsJsonArray());
                this.items.addAll(items);
            }
            CogwheelMaterial.parseJsonPrimitive(object, "stress_limit", JsonPrimitive::isNumber, primitive -> {
                this.speedLimit = primitive.getAsInt();
            });
            CogwheelMaterial.parseJsonPrimitive(object, "speed_limit", JsonPrimitive::isNumber, primitive -> {
                this.speedLimit = primitive.getAsInt();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static ResourceLocation locationFromString(String primitive) {
        try {
            return new ResourceLocation(primitive);
        }
        catch (ResourceLocationException resourceLocationException) {
            return new ResourceLocation("extendedgears", "cogwheels/missing");
        }
    }

    private static NonNullList<Ingredient> ingredientsFromJson(JsonArray ingredientArray) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (JsonElement je : ingredientArray) {
            ingredients.add((Object)Ingredient.m_43917_((JsonElement)je));
        }
        return ingredients;
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.id);
        buffer.m_130130_(this.items.size());
        for (Ingredient item : this.items) {
            item.m_43923_(buffer);
        }
        buffer.writeInt(this.speedLimit);
        buffer.writeInt(this.stressLimit);
    }

    private static void parseJsonPrimitive(JsonObject object, String key, Predicate<JsonPrimitive> predicate, Consumer<JsonPrimitive> consumer) {
        JsonPrimitive primitive;
        JsonElement element = object.get(key);
        if (element != null && element.isJsonPrimitive() && predicate.test(primitive = element.getAsJsonPrimitive())) {
            consumer.accept(primitive);
        }
    }
}

