/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.datagen;

import com.rabbitminers.extendedgears.ExtendedCogwheels;
import com.rabbitminers.extendedgears.base.data.CogwheelConstants;
import com.rabbitminers.extendedgears.base.data.ICogwheelMaterial;
import com.rabbitminers.extendedgears.base.datatypes.CogwheelMaterialList;
import com.rabbitminers.extendedgears.datagen.ExtendedCogwheelsRecipeProvider;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ExtendedCogwheelsStandardRecipeGen
extends ExtendedCogwheelsRecipeProvider {
    private static final String CRAFTING = "crafting/";
    private static final String BASE = "crafting/base/";
    private static final String TO_STANDARD = "crafting/to_standard/";
    private static final String FROM_SMALL = "crafting/from_small/";
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe HALF_SHAFT = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.HALF_SHAFT_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.andesite()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe LARGE_HALF_SHAFT = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.LARGE_HALF_SHAFT_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.andesite()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SHAFTLESS = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.SHAFTLESS_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_206419_(ExtendedCogwheelsRecipeProvider.I.buttons()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe LARGE_SHAFTLESS = this.create((ItemProviderEntry<? extends ItemLike>)ExtendedCogwheelsBlocks.LARGE_SHAFTLESS_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_206419_(ExtendedCogwheelsRecipeProvider.I.buttons()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SMALL_TO_LARGE_HALF_SHAFT = this.smallToLargeRecipe(CogwheelConstants.HALF_SHAFT_COGWHEELS);
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SMALL_TO_LARGE_SHAFTLESS = this.smallToLargeRecipe(CogwheelConstants.SHAFTLESS_COGWHEELS);
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe SHAFTLESS_TO_STANDARD = this.create((ItemProviderEntry<? extends ItemLike>)AllBlocks.COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_((ItemLike)ExtendedCogwheelsBlocks.SHAFTLESS_COGWHEEL.get()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe LARGE_SHAFTLESS_TO_STANDARD = this.create((ItemProviderEntry<? extends ItemLike>)AllBlocks.LARGE_COGWHEEL).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_((ItemLike)ExtendedCogwheelsBlocks.LARGE_SHAFTLESS_COGWHEEL.get()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    ExtendedCogwheelsRecipeProvider.GeneratedRecipe PISTON_EXTENSION_POLE = this.create((ItemProviderEntry<? extends ItemLike>)AllBlocks.PISTON_EXTENSION_POLE).returns(8).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShaped(b -> b.m_126127_(Character.valueOf('A'), ExtendedCogwheelsRecipeProvider.I.andesite()).m_206416_(Character.valueOf('P'), ItemTags.f_13168_).m_126130_("A").m_126130_("P").m_126130_("A"));

    private Couple<ExtendedCogwheelsRecipeProvider.GeneratedRecipe> cogwheelRecipes(Couple<BlockEntry<?>> blocks) {
        ExtendedCogwheelsRecipeProvider.GeneratedRecipe small = this.create((ItemProviderEntry<? extends ItemLike>)((ItemProviderEntry)blocks.getFirst())).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.shaft()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
        ExtendedCogwheelsRecipeProvider.GeneratedRecipe large = this.create((ItemProviderEntry<? extends ItemLike>)((ItemProviderEntry)blocks.getSecond())).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_(ExtendedCogwheelsRecipeProvider.I.shaft()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
        return Couple.create((Object)small, (Object)large);
    }

    private ExtendedCogwheelsRecipeProvider.GeneratedRecipe smallToLargeRecipe(Couple<BlockEntry<?>> blocks) {
        return this.create("small_" + ((BlockEntry)blocks.getSecond()).getId().m_135815_() + "_to_large", (ItemProviderEntry<? extends ItemLike>)((ItemProviderEntry)blocks.getSecond())).unlockedBy(ExtendedCogwheelsRecipeProvider.I::andesite).viaShapeless(b -> b.m_126209_((ItemLike)((BlockEntry)blocks.getFirst()).get()).m_206419_(ExtendedCogwheelsRecipeProvider.I.planks()));
    }

    @Deprecated
    private <T extends Block, E extends Enum<E>> ExtendedCogwheelsRecipeProvider.GeneratedRecipe cogwheelSmeltingRecipe(CogwheelMaterialList<T, E> inputMaterialSet, E input, E output) {
        return this.create((ItemProviderEntry<? extends ItemLike>)inputMaterialSet.get(output)).withSuffix("_from_" + ((ICogwheelMaterial)((Object)input)).asId()).viaCooking((Supplier<? extends ItemLike>)inputMaterialSet.get(input)).rewardXP(1.0f).inBlastFurnace();
    }

    GeneratedRecipeBuilder create(Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(String path, Supplier<ItemLike> result) {
        return new GeneratedRecipeBuilder(path, result);
    }

    GeneratedRecipeBuilder create(ResourceLocation result) {
        return new GeneratedRecipeBuilder("/", result);
    }

    GeneratedRecipeBuilder create(ItemProviderEntry<? extends ItemLike> result) {
        return this.create(() -> result.get());
    }

    GeneratedRecipeBuilder create(String path, ItemProviderEntry<? extends ItemLike> result) {
        return this.create(path, () -> result.get());
    }

    public ExtendedCogwheelsStandardRecipeGen(PackOutput pOutput) {
        super(pOutput);
    }

    @NotNull
    public String m_6055_() {
        return "Extended Cogwheels Crafting Recipes";
    }

    class GeneratedRecipeBuilder {
        private final String path;
        private String suffix;
        private Supplier<? extends ItemLike> result;
        private ResourceLocation compatDatagenOutput;
        private Supplier<ItemPredicate> unlockedBy;
        private int amount;

        private GeneratedRecipeBuilder(String path) {
            this.path = path;
            this.suffix = "";
            this.amount = 1;
        }

        public GeneratedRecipeBuilder(String path, Supplier<? extends ItemLike> result) {
            this(path);
            this.result = result;
        }

        public GeneratedRecipeBuilder(String path, ResourceLocation result) {
            this(path);
            this.compatDatagenOutput = result;
        }

        GeneratedRecipeBuilder returns(int amount) {
            this.amount = amount;
            return this;
        }

        GeneratedRecipeBuilder unlockedBy(Supplier<? extends ItemLike> item) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{(ItemLike)item.get()}).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder unlockedByTag(Supplier<TagKey<Item>> tag) {
            this.unlockedBy = () -> ItemPredicate.Builder.m_45068_().m_204145_((TagKey)tag.get()).m_45077_();
            return this;
        }

        GeneratedRecipeBuilder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        ExtendedCogwheelsRecipeProvider.GeneratedRecipe viaShaped(UnaryOperator<ShapedRecipeBuilder> builder) {
            return ExtendedCogwheelsStandardRecipeGen.this.register(consumer -> {
                ShapedRecipeBuilder b = (ShapedRecipeBuilder)builder.apply(ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        ExtendedCogwheelsRecipeProvider.GeneratedRecipe viaShapeless(UnaryOperator<ShapelessRecipeBuilder> builder) {
            return ExtendedCogwheelsStandardRecipeGen.this.register(consumer -> {
                ShapelessRecipeBuilder b = (ShapelessRecipeBuilder)builder.apply(ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)this.result.get(), (int)this.amount));
                if (this.unlockedBy != null) {
                    b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{this.unlockedBy.get()}));
                }
                b.m_126140_(consumer, this.createLocation("crafting"));
            });
        }

        private ResourceLocation createSimpleLocation(String recipeType) {
            return ExtendedCogwheels.asResource(recipeType + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation createLocation(String recipeType) {
            return ExtendedCogwheels.asResource(recipeType + "/" + this.path + "/" + this.getRegistryName().m_135815_() + this.suffix);
        }

        private ResourceLocation getRegistryName() {
            return this.compatDatagenOutput == null ? RegisteredObjects.getKeyOrThrow((Item)this.result.get().m_5456_()) : this.compatDatagenOutput;
        }

        GeneratedCookingRecipeBuilder viaCooking(Supplier<? extends ItemLike> item) {
            return this.unlockedBy(item).viaCookingIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)item.get()}));
        }

        GeneratedCookingRecipeBuilder viaCookingTag(Supplier<TagKey<Item>> tag) {
            return this.unlockedByTag(tag).viaCookingIngredient(() -> Ingredient.m_204132_((TagKey)((TagKey)tag.get())));
        }

        GeneratedCookingRecipeBuilder viaCookingIngredient(Supplier<Ingredient> ingredient) {
            return new GeneratedCookingRecipeBuilder(ingredient);
        }

        class GeneratedCookingRecipeBuilder {
            private final Supplier<Ingredient> ingredient;
            private float exp;
            private int cookingTime;
            private final SimpleCookingSerializer<?> FURNACE = (SimpleCookingSerializer)RecipeSerializer.f_44091_;
            private final SimpleCookingSerializer<?> SMOKER = (SimpleCookingSerializer)RecipeSerializer.f_44093_;
            private final SimpleCookingSerializer<?> BLAST = (SimpleCookingSerializer)RecipeSerializer.f_44092_;
            private final SimpleCookingSerializer<?> CAMPFIRE = (SimpleCookingSerializer)RecipeSerializer.f_44094_;

            GeneratedCookingRecipeBuilder(Supplier<Ingredient> ingredient) {
                this.ingredient = ingredient;
                this.cookingTime = 200;
                this.exp = 0.0f;
            }

            GeneratedCookingRecipeBuilder forDuration(int duration) {
                this.cookingTime = duration;
                return this;
            }

            GeneratedCookingRecipeBuilder rewardXP(float xp) {
                this.exp = xp;
                return this;
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inFurnace() {
                return this.inFurnace(b -> b);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                return this.create(this.FURNACE, builder, 1.0f);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inSmoker() {
                return this.inSmoker(b -> b);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inSmoker(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                this.create(this.CAMPFIRE, builder, 3.0f);
                return this.create(this.SMOKER, builder, 0.5f);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inBlastFurnace() {
                return this.inBlastFurnace(b -> b);
            }

            ExtendedCogwheelsRecipeProvider.GeneratedRecipe inBlastFurnace(UnaryOperator<SimpleCookingRecipeBuilder> builder) {
                this.create(this.FURNACE, builder, 1.0f);
                return this.create(this.BLAST, builder, 0.5f);
            }

            private ExtendedCogwheelsRecipeProvider.GeneratedRecipe create(SimpleCookingSerializer<?> serializer, UnaryOperator<SimpleCookingRecipeBuilder> builder, float cookingTimeModifier) {
                return ExtendedCogwheelsStandardRecipeGen.this.register(consumer -> {
                    boolean isOtherMod = GeneratedRecipeBuilder.this.compatDatagenOutput != null;
                    SimpleCookingRecipeBuilder b = (SimpleCookingRecipeBuilder)builder.apply(SimpleCookingRecipeBuilder.m_247020_((Ingredient)this.ingredient.get(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)(isOtherMod ? Items.f_42329_ : GeneratedRecipeBuilder.this.result.get()), (float)this.exp, (int)((int)((float)this.cookingTime * cookingTimeModifier))));
                    if (GeneratedRecipeBuilder.this.unlockedBy != null) {
                        b.m_126132_("has_item", (CriterionTriggerInstance)RecipeProvider.m_126011_((ItemPredicate[])new ItemPredicate[]{GeneratedRecipeBuilder.this.unlockedBy.get()}));
                    }
                    b.m_126140_(consumer, GeneratedRecipeBuilder.this.createSimpleLocation(RegisteredObjects.getKeyOrThrow((RecipeSerializer)serializer).m_135815_()));
                });
            }
        }
    }
}

