/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics.renderer.multitexture;

import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.RenderType;

public class MultiTextureRenderTypeRenderer {
    private boolean used;
    private BufferBuilder bufferBuilder = new BufferBuilder(256);
    private List<BufferBuilder.RenderedBuffer> buffersForDrawCalls = new ArrayList<BufferBuilder.RenderedBuffer>();
    private IntArrayList texturesForDrawCalls = new IntArrayList();
    private IntConsumer textureBinderShader;
    private IntConsumer textureBinder;
    private Runnable textureFinalizer;
    private int prevTextureId;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
    }

    void init(IntConsumer textureBinderShader, IntConsumer textureBinder, Runnable textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        this.used = true;
        this.textureBinderShader = textureBinderShader;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTextureId = -1;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            BufferBuilder bufferBuilder = this.bufferBuilder;
            IntConsumer textureBinder = this.textureBinder;
            IntConsumer textureBinderShader = this.textureBinderShader;
            Runnable textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.renderType.m_110185_();
            this.endBuffer(bufferBuilder);
            boolean first = true;
            int shaderProgram = RenderSystem.getShader().m_108943_();
            for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                int texture = this.texturesForDrawCalls.getInt(i);
                BufferBuilder.RenderedBuffer buffer = this.buffersForDrawCalls.get(i);
                if (texture == -1) {
                    texture = 0;
                }
                if (first) {
                    textureBinderShader.accept(texture);
                    BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer);
                    ProgramManager.m_85578_((int)shaderProgram);
                } else {
                    textureBinder.accept(texture);
                    BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)buffer);
                }
                if (hasTextureFinalizer) {
                    if (first) {
                        textureBinder.accept(texture);
                    }
                    textureFinalizer.run();
                }
                first = false;
            }
            textureBinder.accept(0);
            this.renderType.m_110188_();
        }
        ProgramManager.m_85578_((int)0);
        this.texturesForDrawCalls.clear();
        this.buffersForDrawCalls.clear();
        this.used = false;
        this.renderType = null;
    }

    private void endBuffer(BufferBuilder builder) {
        this.buffersForDrawCalls.add(builder.m_231175_());
    }

    public BufferBuilder begin(int textureId) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (textureId == -1) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture id -1!");
        }
        if (textureId != this.prevTextureId) {
            if (this.prevTextureId != -1) {
                this.endBuffer(this.bufferBuilder);
            }
            this.bufferBuilder.m_166779_(this.renderType.m_173186_(), this.renderType.m_110508_());
            this.prevTextureId = textureId;
            this.texturesForDrawCalls.add(textureId);
        }
        return this.bufferBuilder;
    }
}

