/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.config;

import com.cupboard.config.ICommonConfig;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CommonConfiguration
implements ICommonConfig {
    public Set<String> dungeonChestLoottables = new LinkedHashSet<String>(Lists.newArrayList((Object[])new String[]{"chests/abandoned_mineshaft", "chests/bastion_bridge", "chests/bastion_hoglin_stable", "chests/bastion_other", "chests/bastion_treasure", "chests/ancient_city", "chests/ancient_city_ice_box", "chests/desert_pyramid", "chests/end_city_treasure", "chests/igloo_chest", "chests/jungle_temple_dispenser", "chests/jungle_temple", "chests/nether_bridge", "chests/pillager_outpost", "chests/simple_dungeon", "chests/stronghold_corridor", "chests/stronghold_crossing", "chests/stronghold_library", "chests/woodland_mansion"}));
    public Set<String> respawnableStructureIDs = new LinkedHashSet<String>(Lists.newArrayList((Object[])new String[]{"minecraft:desert_pyramid", "minecraft:end_city", "minecraft:fortress", "minecraft:igloo", "minecraft:jungle_temple", "minecraft:mineshaft", "minecraft:ocean_monument", "minecraft:stronghold", "minecraft:woodland_mansion"}));
    public Set<String> blacklistedStructures = new LinkedHashSet<String>();
    public Set<String> dimensionBlackList = new LinkedHashSet<String>();
    public int minutesUntilRespawn = 2880;
    public boolean enableAutomaticRespawn = true;
    public boolean increaseDifficultyWithRespawn = true;

    public JsonObject serialize() {
        JsonObject root = new JsonObject();
        JsonObject entry = new JsonObject();
        entry.addProperty("desc:", "Enables automatic respawning of structures, default:true");
        entry.addProperty("enableAutomaticRespawn", Boolean.valueOf(this.enableAutomaticRespawn));
        root.add("enableAutomaticRespawn", (JsonElement)entry);
        JsonObject entry7 = new JsonObject();
        entry7.addProperty("desc:", "Sets the time after which a structure can respawn, the timer starts after the last activity within the structure. default:2.880 minutes(48h)");
        entry7.addProperty("minutesUntilRespawn", (Number)this.minutesUntilRespawn);
        root.add("minutesUntilRespawn", (JsonElement)entry7);
        JsonObject entry11 = new JsonObject();
        entry11.addProperty("desc:", "Enables increased difficulty with in respawned dungeons(mobs can get enchanted items/potions effects), default: true");
        entry11.addProperty("increaseDifficultyWithRespawn", Boolean.valueOf(this.increaseDifficultyWithRespawn));
        root.add("increaseDifficultyWithRespawn", (JsonElement)entry11);
        JsonObject entry10 = new JsonObject();
        entry10.addProperty("desc:", "List of blacklisted dimension ids, e.g. minecraft:overworld   Seperate multiple entries by , ");
        JsonArray list10 = new JsonArray();
        for (String name : this.dimensionBlackList) {
            list10.add(name);
        }
        entry10.add("dimensionBlackList", (JsonElement)list10);
        root.add("dimensionBlackList", (JsonElement)entry10);
        JsonObject entry8 = new JsonObject();
        entry8.addProperty("desc:", "List of structure IDs that should respawn (others may still be detected and respawn, but this is the surefire way): e.g. minecraft:mansion");
        JsonArray list8 = new JsonArray();
        for (String name : this.respawnableStructureIDs) {
            list8.add(name);
        }
        entry8.add("respawnableStructureIDs", (JsonElement)list8);
        root.add("respawnableStructureIDs", (JsonElement)entry8);
        JsonObject entry6 = new JsonObject();
        entry6.addProperty("desc:", "List of blacklisted structures, those won't respawn ever: e.g. minecraft:mansion   Seperate multiple entries by , ");
        JsonArray list6 = new JsonArray();
        for (String name : this.blacklistedStructures) {
            list6.add(name);
        }
        entry6.add("blacklistedStructures", (JsonElement)list6);
        root.add("blacklistedStructures", (JsonElement)entry6);
        JsonObject entry5 = new JsonObject();
        entry5.addProperty("desc:", "List of loot tables of chests considered to be dungeon loot, partially used for detecting dungeons. Adding additional modded ones improves detection");
        JsonArray list5 = new JsonArray();
        for (String name : this.dungeonChestLoottables) {
            list5.add(name);
        }
        entry5.add("dungeonChestLoottables", (JsonElement)list5);
        root.add("dungeonChestLoottables", (JsonElement)entry5);
        return root;
    }

    public void deserialize(JsonObject data) {
        this.minutesUntilRespawn = data.get("minutesUntilRespawn").getAsJsonObject().get("minutesUntilRespawn").getAsInt();
        this.enableAutomaticRespawn = data.get("enableAutomaticRespawn").getAsJsonObject().get("enableAutomaticRespawn").getAsBoolean();
        this.increaseDifficultyWithRespawn = data.get("increaseDifficultyWithRespawn").getAsJsonObject().get("increaseDifficultyWithRespawn").getAsBoolean();
        this.dungeonChestLoottables = new HashSet<String>();
        for (JsonElement element : data.get("dungeonChestLoottables").getAsJsonObject().get("dungeonChestLoottables").getAsJsonArray()) {
            this.dungeonChestLoottables.add(element.getAsString());
        }
        this.blacklistedStructures = new HashSet<String>();
        for (JsonElement element : data.get("blacklistedStructures").getAsJsonObject().get("blacklistedStructures").getAsJsonArray()) {
            this.blacklistedStructures.add(element.getAsString());
        }
        this.dimensionBlackList = new HashSet<String>();
        for (JsonElement element : data.get("dimensionBlackList").getAsJsonObject().get("dimensionBlackList").getAsJsonArray()) {
            this.dimensionBlackList.add(element.getAsString());
        }
        this.respawnableStructureIDs = new HashSet<String>();
        for (JsonElement element : data.get("respawnableStructureIDs").getAsJsonObject().get("respawnableStructureIDs").getAsJsonArray()) {
            this.respawnableStructureIDs.add(element.getAsString());
        }
    }
}

