/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.event;

import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import java.util.Calendar;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private static long lastTime = 0L;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.getServer().m_129921_() % 100 == 35) {
            if (lastTime == 0L) {
                lastTime = Calendar.getInstance().getTimeInMillis();
                return;
            }
            if (event.getServer().m_7416_() > 0 && Calendar.getInstance().getTimeInMillis() - lastTime > 300000L) {
                lastTime = Calendar.getInstance().getTimeInMillis();
                for (ServerLevel level : event.getServer().m_129785_()) {
                    RespawnLevelData data = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
                    if (data == null) continue;
                    data.increaseTime(300);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.level.f_46443_ && event.level.m_46467_() % 1000L == 17L) {
            RespawnManager.onLevelTick((ServerLevel)event.level);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPlayer() instanceof ServerPlayer) {
            if (event.getState().m_155947_() && event.getLevel().m_7702_(event.getPos()) instanceof SpawnerBlockEntity) {
                RespawnManager.onSpawnerKilled((SpawnerBlockEntity)event.getLevel().m_7702_(event.getPos()));
            } else {
                RespawnManager.onBlockBreak((ServerPlayer)event.getPlayer(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            if (event.getState().m_60791_() > 0) {
                RespawnManager.onLightPlaced((ServerPlayer)event.getEntity(), event.getPos());
            } else {
                RespawnManager.onBlockPlaced((ServerPlayer)event.getEntity(), event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (!event.getLevel().m_5776_()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public static void onMobKilled(LivingDeathEvent event) {
        if (!event.getEntity().m_9236_().m_5776_() && event.getSource().m_7639_() instanceof ServerPlayer) {
            RespawnManager.onMobKilled(event.getEntity());
        } else if (event.getEntity() instanceof ServerPlayer) {
            RespawnManager.onPlayerDeath((ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityAdded(EntityJoinLevelEvent event) {
        if (!event.getLevel().f_46443_ && !RespawnManager.tryAddEntityDuringRespawn(event.getEntity(), (ServerLevel)event.getLevel(), event.getEntity().m_20183_())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityAdded(MobSpawnEvent.FinalizeSpawn event) {
        if (!event.getLevel().m_5776_() && event.getSpawnType() == MobSpawnType.SPAWNER && event.getEntity() != null) {
            RespawnManager.onSpawnerSpawn(event.getEntity());
        }
    }
}

