/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.mixin;

import com.respawningstructures.structure.RespawnManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Containers.class})
public class ContainerDropRespawnMixin {
    @Inject(method={"dropItemStack"}, at={@At(value="HEAD")}, cancellable=true)
    private static void preventDropOnRespawn(Level p_18993_, double p_18994_, double p_18995_, double p_18996_, ItemStack p_18997_, CallbackInfo ci) {
        if (RespawnManager.respawnInProgress != null) {
            ci.cancel();
        }
    }

    @Inject(method={"dropContents(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/Container;)V"}, at={@At(value="HEAD")})
    private static void onLootDropped(Level level, double x, double y, double z, Container container, CallbackInfo ci) {
        if (level instanceof ServerLevel) {
            if (container instanceof RandomizableContainerBlockEntity) {
                if (((RandomizableContainerBlockEntity)container).f_59605_ != null) {
                    RespawnManager.onChestLooted((ServerLevel)level, ((RandomizableContainerBlockEntity)container).f_59605_, BlockPos.m_274561_((double)x, (double)y, (double)z));
                }
            } else if (container instanceof ContainerEntity && ((ContainerEntity)container).m_214142_() != null) {
                RespawnManager.onChestLooted((ServerLevel)level, ((ContainerEntity)container).m_214142_(), BlockPos.m_274561_((double)x, (double)y, (double)z));
            }
        }
    }
}

