/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.structures.DesertPyramidPiece;
import net.minecraft.world.level.levelgen.structure.structures.JungleTemplePiece;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressPieces;
import net.minecraft.world.level.levelgen.structure.structures.StrongholdPieces;
import net.minecraft.world.phys.AABB;

public class RespawnManager {
    public static volatile StructureData respawnInProgress = null;
    public static Object2IntOpenHashMap<EntityType> entityCounts = new Object2IntOpenHashMap();
    private static List<MobEffect> randomEffects = List.of(MobEffects.f_19606_, MobEffects.f_19607_, MobEffects.f_19605_, MobEffects.f_19600_, MobEffects.f_19607_, MobEffects.f_19617_, MobEffects.f_216964_, MobEffects.f_19603_);

    public static StructureData getForPos(ServerLevel level, BlockPos pos, boolean update) {
        RespawnLevelData respawnData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        return respawnData.getForPos(level, pos, update);
    }

    public static void onSpawnerKilled(SpawnerBlockEntity entity) {
        StructureData structureData;
        if (entity.m_58898_() && !entity.m_58904_().m_5776_() && (structureData = RespawnManager.getForPos((ServerLevel)entity.m_58904_(), entity.m_58899_(), true)) != null) {
            ++structureData.spawnerBreak;
        }
    }

    public static void onSpawnerActive(ServerLevel level, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos(level, pos, true);
        if (structureData != null) {
            ++structureData.spawnerActivations;
        }
    }

    public static void onChestLooted(ServerLevel level, ResourceLocation lootTable, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos(level, pos, true);
        if (structureData != null) {
            if (lootTable.m_135815_().toLowerCase().contains("dungeon") || ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).dungeonChestLoottables.contains(lootTable.m_135815_())) {
                ++structureData.dungeonContainerLooted;
            } else {
                ++structureData.containerLooted;
            }
        }
    }

    public static void onMobKilled(LivingEntity entity) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)entity.m_9236_(), entity.m_20183_(), true);
        if (structureData != null) {
            ++structureData.mobsKilled;
        }
    }

    public static void onBlockBreak(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.blocksBroken;
        }
    }

    public static void onLightPlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.lightsPlaced;
        }
    }

    public static void onBlockPlaced(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.blocksPlaced;
        }
    }

    public static void onPlayerDeath(ServerPlayer player) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), player.m_20183_(), true);
        if (structureData != null) {
            ++structureData.playerDeaths;
        }
    }

    public static void onPortalUsage(ServerPlayer player, BlockPos pos) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)player.m_9236_(), pos, true);
        if (structureData != null) {
            ++structureData.portalUsage;
        }
    }

    public static void onLevelTick(ServerLevel level) {
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).dimensionBlackList.contains(level.m_46472_().m_135782_().toString())) {
            return;
        }
        RespawnLevelData respawnData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        for (StructureData data : respawnData.getAllStructureData()) {
            if (!data.canRespawn(level)) continue;
            data.respawn(level);
            break;
        }
    }

    public static boolean respawnStructure(ServerLevel level, StructureData structureData, boolean checkLoaded) {
        if (structureData == null) {
            return false;
        }
        if (checkLoaded && !level.m_7232_(structureData.pos.m_123170_(), structureData.pos.m_123222_())) {
            return false;
        }
        RespawnLevelData respawnData = (RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata");
        if (respawnData == null) {
            return false;
        }
        structureData.fillStructureStart(level);
        StructureStart structureStart = structureData.getStructureStart();
        if (!structureStart.m_73603_()) {
            return false;
        }
        long time = System.nanoTime();
        BoundingBox boundingbox = structureStart.m_73601_();
        ChunkPos chunkPosMin = new ChunkPos(SectionPos.m_123171_((int)boundingbox.m_162395_()), SectionPos.m_123171_((int)boundingbox.m_162398_()));
        ChunkPos chunkPosMax = new ChunkPos(SectionPos.m_123171_((int)boundingbox.m_162399_()), SectionPos.m_123171_((int)boundingbox.m_162401_()));
        if (checkLoaded) {
            int loaded = 0;
            int unloaded = 0;
            for (int x = chunkPosMin.f_45578_; x <= chunkPosMax.f_45578_; ++x) {
                for (int z = chunkPosMax.f_45579_; z <= chunkPosMax.f_45579_; ++z) {
                    if (!level.m_7232_(x, z)) {
                        ++unloaded;
                        continue;
                    }
                    ++loaded;
                }
            }
            if (loaded + unloaded > 0 && (double)unloaded / (double)(loaded + unloaded) > 0.3) {
                return false;
            }
        }
        RespawningStructures.LOGGER.info("Respawning structure: " + structureData.id + " at: " + structureData.pos.m_123249_());
        respawnInProgress = structureData;
        ++structureData.respawns;
        respawnData.m_77762_();
        List entities = level.m_45976_(Entity.class, new AABB((double)boundingbox.m_162395_(), (double)boundingbox.m_162396_(), (double)boundingbox.m_162398_(), (double)boundingbox.m_162399_(), (double)boundingbox.m_162400_(), (double)boundingbox.m_162401_()).m_82400_(20.0));
        entityCounts = new Object2IntOpenHashMap();
        for (Entity existing : entities) {
            entityCounts.put((Object)existing.m_6095_(), entityCounts.getOrDefault((Object)existing.m_6095_(), 0) + 1);
        }
        for (StructurePiece piece : structureStart.m_73602_()) {
            if (checkLoaded) {
                if (!boundingbox.m_260866_(piece.m_73547_().m_162399_(), piece.m_73547_().m_162400_(), piece.m_73547_().m_162401_()) && !level.m_7232_(piece.m_73547_().m_162399_() >> 4, piece.m_73547_().m_162401_() >> 4)) {
                    return false;
                }
                if (!boundingbox.m_260866_(piece.m_73547_().m_162395_(), piece.m_73547_().m_162396_(), piece.m_73547_().m_162398_()) && !level.m_7232_(piece.m_73547_().m_162395_() >> 4, piece.m_73547_().m_162398_() >> 4)) {
                    return false;
                }
            }
            if (piece instanceof NetherFortressPieces.MonsterThrone) {
                ((NetherFortressPieces.MonsterThrone)piece).f_228354_ = false;
            }
            if (piece instanceof StrongholdPieces.PortalRoom) {
                ((StrongholdPieces.PortalRoom)piece).f_229627_ = false;
            }
            if (piece instanceof StrongholdPieces.ChestCorridor) {
                ((StrongholdPieces.ChestCorridor)piece).f_229463_ = false;
            }
            if (piece instanceof MineshaftPieces.MineShaftCorridor) {
                ((MineshaftPieces.MineShaftCorridor)piece).f_227728_ = false;
            }
            if (piece instanceof DesertPyramidPiece) {
                ((DesertPyramidPiece)piece).f_227397_[0] = false;
                ((DesertPyramidPiece)piece).f_227397_[1] = false;
                ((DesertPyramidPiece)piece).f_227397_[2] = false;
                ((DesertPyramidPiece)piece).f_227397_[3] = false;
            }
            if (piece instanceof JungleTemplePiece) {
                ((JungleTemplePiece)piece).f_227661_ = false;
                ((JungleTemplePiece)piece).f_227662_ = false;
            }
            if (piece instanceof NetherFortressPieces.CastleSmallCorridorLeftTurnPiece) {
                boolean bl = ((NetherFortressPieces.CastleSmallCorridorLeftTurnPiece)piece).f_228230_ = RespawningStructures.rand.nextInt(3) == 0;
            }
            if (!(piece instanceof NetherFortressPieces.CastleSmallCorridorRightTurnPiece)) continue;
            ((NetherFortressPieces.CastleSmallCorridorRightTurnPiece)piece).f_228292_ = RespawningStructures.rand.nextInt(3) == 0;
        }
        ChunkPos.m_45599_((ChunkPos)chunkPosMin, (ChunkPos)chunkPosMax).forEach(chunPos -> {
            structureStart.m_226850_((WorldGenLevel)level, level.m_215010_(), level.m_7726_().m_8481_(), level.m_213780_(), new BoundingBox(chunPos.m_45604_(), level.m_141937_(), chunPos.m_45605_(), chunPos.m_45608_(), level.m_151558_(), chunPos.m_45609_()), chunPos);
            level.m_6325_(chunPos.f_45578_, chunPos.f_45579_).m_62812_();
        });
        time = System.nanoTime() - time;
        if ((double)time / 1.0E9 > 20.0) {
            RespawningStructures.LOGGER.warn("Structure:" + structureData.id + " took over 20 seconds to respawn, if you want to avoid lagspikes it is recommended to put this ID on the blacklist:" + structureData.id);
        }
        structureData.onRespawnReset();
        respawnInProgress = null;
        return true;
    }

    public static boolean tryAddEntityDuringRespawn(Entity entity, ServerLevel level, BlockPos pos) {
        if (respawnInProgress != null) {
            if (entityCounts.getInt((Object)entity.m_6095_()) > 0) {
                entityCounts.put((Object)entity.m_6095_(), entityCounts.getInt((Object)entity.m_6095_()) - 1);
                return false;
            }
            if (entity instanceof Mob) {
                RespawnManager.applyRespawnBonus((Mob)entity, respawnInProgress);
            }
        }
        return true;
    }

    public static void onSpawnerSpawn(Mob entity) {
        StructureData structureData = RespawnManager.getForPos((ServerLevel)entity.m_9236_(), entity.m_20183_(), true);
        if (structureData != null && structureData.respawns > 0) {
            RespawnManager.applyRespawnBonus(entity, structureData);
        }
    }

    private static void applyRespawnBonus(Mob entity, StructureData structureData) {
        if (!((CommonConfiguration)RespawningStructures.config.getCommonConfig()).increaseDifficultyWithRespawn) {
            return;
        }
        int respawnDifficulty = Math.min(4, structureData.respawns);
        for (int i = 0; i < respawnDifficulty; ++i) {
            ItemStack stack = null;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot == EquipmentSlot.OFFHAND || entity.m_6844_(slot).m_41619_() || !entity.m_6844_(slot).m_41785_().isEmpty()) continue;
                stack = entity.m_6844_(slot);
                break;
            }
            if (stack == null && RespawningStructures.rand.nextInt(10) == 0) {
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (!entity.m_6844_(slot).m_41619_() || slot == EquipmentSlot.OFFHAND) continue;
                    if (slot == EquipmentSlot.MAINHAND) {
                        stack = Items.f_42383_.m_7968_();
                        entity.m_8061_(slot, stack);
                    }
                    if (slot == EquipmentSlot.CHEST) {
                        stack = Items.f_42469_.m_7968_();
                        entity.m_8061_(slot, stack);
                    }
                    if (slot == EquipmentSlot.HEAD) {
                        stack = Items.f_42468_.m_7968_();
                        entity.m_8061_(slot, stack);
                    }
                    if (slot == EquipmentSlot.LEGS) {
                        stack = Items.f_42470_.m_7968_();
                        entity.m_8061_(slot, stack);
                    }
                    if (slot != EquipmentSlot.FEET) break;
                    stack = Items.f_42471_.m_7968_();
                    entity.m_8061_(slot, stack);
                    break;
                }
            }
            if (stack != null) {
                EnchantmentHelper.m_220292_((RandomSource)entity.m_217043_(), stack, (int)respawnDifficulty, (boolean)true);
                continue;
            }
            MobEffect randomEffect = randomEffects.get(RespawningStructures.rand.nextInt(randomEffects.size()));
            if (entity.m_21023_(randomEffect)) continue;
            entity.m_7292_(new MobEffectInstance(randomEffect, -1));
        }
    }
}

