/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureData {
    public static final StructureData EMPTY = new StructureData(BlockPos.f_121853_, new ResourceLocation("dummy"));
    private static final int DATA_VERSION = 1;
    public final SectionPos pos;
    public final ResourceLocation id;
    private StructureStart structureStart = null;
    public int bbSize = 0;
    public boolean disabledRespawn = false;
    public int spawnerActivations = 0;
    public int spawnerBreak = 0;
    public int containerLooted = 0;
    public int dungeonContainerLooted = 0;
    public int lightsPlaced = 0;
    public int blocksPlaced = 0;
    public int blocksBroken = 0;
    public int mobsKilled = 0;
    public int playerDeaths = 0;
    public int portalUsage = 0;
    public long lastActivity = 0L;
    public int respawns = 0;

    public StructureData(BlockPos pos, ResourceLocation id) {
        this.pos = SectionPos.m_123199_((BlockPos)pos);
        this.id = id;
    }

    public boolean doesFulfillRespawnRequirements(long currentTime) {
        return false;
    }

    public void setLastModifiedTime(long timepoint) {
        this.lastActivity = timepoint;
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("version", 1);
        tag.m_128405_("posx", this.pos.m_123341_());
        tag.m_128405_("posy", this.pos.m_123342_());
        tag.m_128405_("posz", this.pos.m_123343_());
        tag.m_128359_("id", this.id.toString());
        tag.m_128379_("disabledRespawn", this.disabledRespawn);
        tag.m_128405_("spawnerActivations", this.spawnerActivations);
        tag.m_128405_("bbSize", this.bbSize);
        tag.m_128405_("spawnerBreak", this.spawnerBreak);
        tag.m_128405_("portalUsage", this.portalUsage);
        tag.m_128405_("containerLooted", this.containerLooted);
        tag.m_128405_("dungeonContainerLooted", this.dungeonContainerLooted);
        tag.m_128405_("lightsPlaced", this.lightsPlaced);
        tag.m_128405_("blocksPlaced", this.blocksPlaced);
        tag.m_128405_("blocksBroken", this.blocksBroken);
        tag.m_128405_("mobsKilled", this.mobsKilled);
        tag.m_128405_("playerDeaths", this.playerDeaths);
        tag.m_128405_("respawns", this.respawns);
        tag.m_128356_("lastActivity", this.lastActivity);
        return tag;
    }

    public StructureData(CompoundTag tag) {
        int version = tag.m_128451_("version");
        this.pos = SectionPos.m_123173_((int)tag.m_128451_("posx"), (int)tag.m_128451_("posy"), (int)tag.m_128451_("posz"));
        this.id = ResourceLocation.m_135820_((String)tag.m_128461_("id"));
        this.spawnerActivations = tag.m_128451_("spawnerActivations");
        this.bbSize = tag.m_128451_("bbSize");
        this.disabledRespawn = tag.m_128471_("disabledRespawn");
        this.spawnerBreak = tag.m_128451_("spawnerBreak");
        this.portalUsage = tag.m_128451_("portalUsage");
        this.containerLooted = tag.m_128451_("containerLooted");
        this.dungeonContainerLooted = tag.m_128451_("dungeonContainerLooted");
        this.lightsPlaced = tag.m_128451_("lightsPlaced");
        this.blocksPlaced = tag.m_128451_("blocksPlaced");
        this.blocksBroken = tag.m_128451_("blocksBroken");
        this.mobsKilled = tag.m_128451_("mobsKilled");
        this.playerDeaths = tag.m_128451_("playerDeaths");
        this.respawns = tag.m_128451_("respawns");
        this.lastActivity = tag.m_128454_("lastActivity");
    }

    public StructureStart fillStructureStart(ServerLevel level) {
        if (this.structureStart != null) {
            return this.structureStart;
        }
        for (Map.Entry entry : level.m_215010_().m_220522_(this.pos.m_123250_()).entrySet()) {
            if (!this.id.equals((Object)((Registry)level.m_9598_().m_6632_(Registries.f_256944_).get()).m_7981_((Object)((Structure)entry.getKey())))) continue;
            level.m_215010_().m_220480_((Structure)entry.getKey(), (LongSet)entry.getValue(), structureStart -> {
                if (SectionPos.m_123199_((BlockPos)structureStart.m_73601_().m_162394_()).equals((Object)this.pos)) {
                    this.structureStart = structureStart;
                }
            });
        }
        if (this.structureStart == null) {
            RespawningStructures.LOGGER.warn("failed to fill!");
        }
        return this.structureStart;
    }

    public boolean respawn(ServerLevel level) {
        if (this.canRespawn(level)) {
            return RespawnManager.respawnStructure(level, this, true);
        }
        return false;
    }

    public boolean canRespawn(ServerLevel level) {
        if (!((CommonConfiguration)RespawningStructures.config.getCommonConfig()).enableAutomaticRespawn || this.disabledRespawn) {
            return false;
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.contains(this.id.toString())) {
            return false;
        }
        if (this.lastActivity == 0L || ((RespawnLevelData)level.m_8895_().m_164861_(RespawnLevelData::load, RespawnLevelData::new, "respawningdungeonsdata")).getLevelTime() - this.lastActivity < (long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L) {
            return false;
        }
        if (this.checkBlockingStats()) {
            return false;
        }
        return this.checkStats();
    }

    public boolean checkStats() {
        if (this.spawnerBreak > 0) {
            return true;
        }
        if (this.dungeonContainerLooted > 0) {
            return true;
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs.contains(this.id.toString()) && this.spawnerActivations + this.containerLooted + this.lightsPlaced + this.blocksPlaced + this.blocksBroken + this.mobsKilled + this.playerDeaths > 3) {
            return true;
        }
        return this.spawnerActivations * 3 + this.containerLooted * 10 + this.lightsPlaced * 3 + this.blocksPlaced + this.blocksBroken + this.mobsKilled * 4 + this.playerDeaths * 10 > 30;
    }

    public boolean checkBlockingStats() {
        if (this.portalUsage > 0) {
            return true;
        }
        return (double)this.blocksPlaced > 100.0 + (double)this.bbSize / 10000.0 && (double)this.blocksBroken > 20.0 + (double)this.bbSize / 100000.0;
    }

    public StructureStart getStructureStart() {
        return this.structureStart;
    }

    public void setStructureStart(StructureStart structureStart) {
        Vec3i length = structureStart.m_73601_().m_71053_();
        this.bbSize = length.m_123341_() * length.m_123342_() * length.m_123343_();
        this.structureStart = structureStart;
    }

    public void onRespawnReset() {
        this.spawnerActivations = 0;
        this.spawnerBreak = 0;
        this.containerLooted = 0;
        this.dungeonContainerLooted = 0;
        this.lightsPlaced = 0;
        this.blocksPlaced = 0;
        this.blocksBroken = 0;
        this.mobsKilled = 0;
        this.playerDeaths = 0;
        this.portalUsage = 0;
        this.lastActivity = 0L;
    }
}

